% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_MD.R
\name{es_from_ancova_md_pval}
\alias{es_from_ancova_md_pval}
\title{Convert an adjusted mean difference and adjusted standard deviation between two independent groups obtained from an ANCOVA model into several effect size measures}
\usage{
es_from_ancova_md_pval(
  ancova_md,
  ancova_md_pval,
  cov_outcome_r,
  n_cov_ancova,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_ancova_md
)
}
\arguments{
\item{ancova_md}{adjusted mean difference between two independent groups}

\item{ancova_md_pval}{p-value (two-tailed) of the adjusted mean difference}

\item{cov_outcome_r}{correlation between the outcome and covariate (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_md}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 20. Adjusted: Mean difference and dispersion'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert an adjusted mean difference and adjusted standard deviation between two independent groups obtained from an ANCOVA model into several effect size measures
}
\details{
This function converts the mean difference (MD) p-value into a standard error,
and then relies on the calculations of the \code{\link{es_from_ancova_md_se}()} function.

\strong{To convert the p-value into a standard error,} the following formula is used (table 12.3 in Cooper):
\deqn{t = qt(p = \frac{ancova\_md\_pval}{2}, df = n\_exp + n\_nexp - 2 - n\_cov\_ancova)}
\deqn{ancova\_md\_se = | \frac{ancova\_md}{t} |}
Calculations of the \code{\link{es_from_ancova_md_se}()} are then applied.
}
\examples{
es_from_ancova_md_pval(
  ancova_md = 4, ancova_md_pval = 0.05,
  cov_outcome_r = 0.5, n_cov_ancova = 5,
  n_exp = 20, n_nexp = 22
)
}
