% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_MD.R
\name{es_from_ancova_md_sd}
\alias{es_from_ancova_md_sd}
\title{Convert an adjusted mean difference and adjusted standard deviation between two independent groups obtained from an ANCOVA model into several effect size measures}
\usage{
es_from_ancova_md_sd(
  ancova_md,
  ancova_md_sd,
  cov_outcome_r,
  n_cov_ancova,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_ancova_md
)
}
\arguments{
\item{ancova_md}{adjusted mean difference between two independent groups}

\item{ancova_md_sd}{covariate-adjusted standard deviation of the mean difference}

\item{cov_outcome_r}{correlation between the outcome and covariate (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_md}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 20. Adjusted: Mean difference and dispersion'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert an adjusted mean difference and adjusted standard deviation between two independent groups obtained from an ANCOVA model into several effect size measures
}
\details{
This function first computes an "adjusted" Cohen's d (D), Hedges' g (G)
from the adjusted mean difference (MD).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate the unadjusted variance of MD} (table 12.3 in Cooper):
\deqn{md\_sd = \frac{ancova\_md\_sd}{\sqrt{1 - cor\_outcome\_r^2}}}
\deqn{md\_se = md\_sd * \sqrt{\frac{1}{n\_exp} + \frac{1}{n\_nexp}}}
\deqn{md\_lo = md - md\_se * qt(.975, n\_exp + n\_nexp-2-n\_cov\_ancova)}
\deqn{md\_up = md + md\_se * qt(.975, n\_exp + n\_nexp-2-n\_cov\_ancova)}

\strong{To estimate the Cohen's d} (table 12.3 in Cooper):
\deqn{d = \frac{ancova\_md}{md\_sd}}

\strong{To estimate other effect size measures},
Calculations of the \code{\link{es_from_cohen_d_adj}()} are applied.
}
\examples{
es_from_ancova_md_sd(
  ancova_md = 4, ancova_md_sd = 2,
  cov_outcome_r = 0.5, n_cov_ancova = 5,
  n_exp = 20, n_nexp = 22
)
}
