% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANOVA_statistics.R
\name{es_from_anova_f}
\alias{es_from_anova_f}
\title{Convert a one-way independent ANOVA F-value to several effect size measures}
\usage{
es_from_anova_f(
  anova_f,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_anova_f
)
}
\arguments{
\item{anova_f}{ANOVA F-value (one-way, binary predictor).}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{anova_f} value into a coefficient correlation (see details).}

\item{reverse_anova_f}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 11. ANOVA statistics, Student's t-test, or point-bis correlation'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a one-way independent ANOVA F-value to several effect size measures
}
\details{
This function converts the F-value (one-way, binary predictor) into a t-value,
and then relies on the calculations of the \code{\link{es_from_student_t}()} function.

\strong{To convert the F-value into a t-value,} the following formula is used (table 12.1 in Cooper):
\deqn{student\_t = \sqrt{anova\_f}}
Then, calculations of the \code{\link{es_from_student_t}()} are applied.
}
\examples{
es_from_anova_f(anova_f = 2.01, n_exp = 20, n_nexp = 22)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
