% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_point_biserial_COR.R
\name{es_from_pt_bis_r}
\alias{es_from_pt_bis_r}
\title{Convert a point-biserial correlation coefficient into several effect size measures}
\usage{
es_from_pt_bis_r(
  pt_bis_r,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_pt_bis_r
)
}
\arguments{
\item{pt_bis_r}{value of a point-biserial correlation coefficient}

\item{n_exp}{total number of participants in the exposed group}

\item{n_nexp}{total number of participants in the non exposed group}

\item{smd_to_cor}{formula used to convert the \code{pt_bis_r} value into a coefficient correlation.}

\item{reverse_pt_bis_r}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 11. ANOVA statistics, Student's t-test, or point-bis correlation'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert a point-biserial correlation coefficient into several effect size measures
}
\details{
This function uses a point-biserial correlation coefficient to estimate a
Cohen's d (D) and Hedges' g (G).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{The formula used to obtain the Cohen's d are (Viechtbauer, 2021)}:
\deqn{m = n\_exp + n\_nexp - 2}
\deqn{h = \frac{m}{n\_exp} + \frac{m}{n\_nexp}}
\deqn{d = \frac{pt\_bis\_r * \sqrt{h}}{\sqrt{1 - pt\_bis\_r^2}}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_pt_bis_r(pt_bis_r = 0.2, n_exp = 121, n_nexp = 121)
}
\references{
Viechtbauer (2021). Accessed at: https://stats.stackexchange.com/questions/526789/convert-correlation-r-to-cohens-d-unequal-groups-of-known-size
}
