% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{summary.minima}
\alias{summary.minima}
\title{Print minima object summary}
\usage{
\method{summary}{minima}(object, temp = 300, eunit = "kJ/mol", ...)
}
\arguments{
\item{object}{minima object}

\item{temp}{temperature in Kelvins}

\item{eunit}{energy units (kJ/mol or kcal/mol, kJ/mol is default)}

\item{...}{further arguments passed to or from other methods.}
}
\description{
`summary.minima` prints summary for free energy minima (identifier, values of bins and collective variables,
free energy and equilibrium populations).
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
summary(minima)
}
