% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metagam.R
\name{plot.metagam}
\alias{plot.metagam}
\title{Plot estimated smooth terms}
\usage{
\method{plot}{metagam}(x, ...)
}
\arguments{
\item{x}{Object returned by \code{\link{metagam}}.}

\item{...}{Other arguments to plot.}
}
\value{
A ggplot object plotting a smooth term of interest along an axis. The meta-analytic
fit is shown as a solid black line, and the cohort fits are shown as dashed lines, separated by
color codes.
}
\description{
Plot the meta-analytic estimate of a smooth term along with the separate fits in each cohort.
}
\details{
This function currently works for meta-analytic estimates of a single smooth term, which can be either
univariate or bivariate. It also works for alternatively meta-analysis of response or link functions.
}
\examples{
library(metagam)
library(mgcv)

## Create 5 datasets
set.seed(1234)
datasets <- lapply(1:5, function(x) gamSim(scale = 5, verbose = FALSE))

## Fit a GAM in each dataset, then use strip_rawdata() to remove
## individual participant data
models <- lapply(datasets, function(dat){
  ## This uses the gam() function from mgcv
  model <- gam(y ~ s(x0, bs = "cr") + s(x1, bs = "cr") + s(x2, bs = "cr"), data = dat)
  ## This uses strip_rawdata() from metagam
  strip_rawdata(model)
})

## Next, we meta-analyze the models.
## It is often most convenient to analyze a single term at a time. We focus on s(x1).
meta_analysis <- metagam(models, terms = "s(x1)", grid_size = 30)

## We can print some information
summary(meta_analysis)

## We can plot the fit
plot(meta_analysis)

}
