% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_between_study_sd.R
\name{plot_between_study_sd}
\alias{plot_between_study_sd}
\title{Plot between-study standard deviation}
\usage{
plot_between_study_sd(x)
}
\arguments{
\item{x}{Object returned from \code{\link{metagam}}.}
}
\value{
A \code{ggplot} object.
}
\description{
When a random effects meta analysis has been used, this function
visualizes how the between-study standard deviation depends on the
explanatory variable.
}
\examples{
library("mgcv")
set.seed(1233)
shifts <- c(0, .5, 1, 0, -1)
datasets <- lapply(shifts, function(x) {
  ## Simulate data
  dat <- gamSim(scale = .1, verbose = FALSE)
  ## Add a shift
  dat$y <- dat$y + x * dat$x2^2
  ## Return data
  dat
})

models <- lapply(datasets, function(dat){
  b <- gam(y ~ s(x2, bs = "cr"), data = dat)
  strip_rawdata(b)
})

meta_analysis <- metagam(models, method = "REML")

plot_between_study_sd(meta_analysis)


}
