% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/abstract_screener.R
\name{abstract_screener}
\alias{abstract_screener}
\title{A GUI screener to quickly code candidate studies for inclusion/exclusion into
a systematic review or meta-analysis.}
\usage{
abstract_screener(file = file.choose(), aReviewer = NULL,
  reviewerColumnName = "REVIEWERS", unscreenedColumnName = "INCLUDE",
  unscreenedValue = "not vetted", abstractColumnName = "ABSTRACT",
  titleColumnName = "TITLE")
}
\arguments{
\item{file}{The file name and location of a .csv file containing the
abstracts and titles.  The .csv file should have been initialized with
\code{effort_initialize} and populated with screeners (reviewers) using
\code{effort_distribute}.}

\item{aReviewer}{The name (a string) of the reviewer to screen abstracts.
It is used when there are multiple reviewers assigned to screen abstracts.
The default column label is "REVIEWERS" as initialized with
\code{effort_distribute}.}

\item{reviewerColumnName}{The name of the column heading in the .csv file
that contains the reviewer names that will screen abstracts.  The default
column label is "REVIEWERS".}

\item{unscreenedColumnName}{The name of the column heading in the .csv file
that contains the screening outcomes (i.e. vetting outcomes by a reviewer).
Unscreened references are by default labeled as "not vetted".  The
reviewer then can code to "YES" (is a relevant study), "NO" is not relevant
and should be excluded, or "MAYBE" if the title/abstract is missing or
does not contains enough information to fully assess inclusivity.
The default label of this column is "INCLUDE".}

\item{unscreenedValue}{Changes the default coding (a string) of "not vetted"
that designates whether an abstract remains to be screened or vetted.}

\item{abstractColumnName}{The name of the column heading in the .csv file
that contains the abstracts. The default label of this column is "ABSTRACT".}

\item{titleColumnName}{The name of the column heading in the .csv file
   that contains the titles. The default label of this column is "TITLE".}
}
\description{
A GUI screener to help scan and evaluate the title and abstract of studies to
be included in a systematic review or meta-analysis.
}
\note{
Upon first use, \code{abstract_screener} will download the gWidgets package
   and associated toolkits needed to build GUI interfaces.  A small window will
   also prompt you to download GTK+ asking "Need GTK+ ?".  From the listed
   options answer: "Install GTK+" and click 'OK'.  Once installed these will
   not be downloaded again.  Sometimes there is an issue with the installation
   of GTK+, see \url{http://www.learnanalytics.in/blog/?p=31} for advice based
   on the \code{Rattle} R Package (both \code{Rattle} and \code{metagear} use
   the same GUI dependencies).  The GUI itself will appear as a single window
   with the first title/abstract listed in the .csv file.  If abstracts have
   already been screened/coded, it will begin at the nearest reference labeled
   as "not vetted".  The SEARCH WEB button opens the default browser and
   searches Google with the title of the reference.  The YES, MAYBE, NO
   buttons, which also have shortcuts ALT-Y and ALT-N, are used to code the
   inclusion/exclusion of the reference.  Once clicked/coded the next reference
   is loaded.  The SAVE button is used to save the coding progress of
   screening tasks.  It will save coding progress directly to the loaded .csv file.
   Closing the GUI and not saving will result in the loss of screening efforts
   relative to last save.
}
\examples{
\dontrun{

data(example_references_metagear)
effort_distribute(example_references_metagear,
                  initialize = TRUE, reviewers = "marc", save_split = TRUE)
abstract_screener("effort_marc.csv", aReviewer = "marc")
}
}

