% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effort_initialize.R
\name{effort_initialize}
\alias{effort_initialize}
\title{Formats a reference dataset for title/abstract screening efforts.}
\usage{
effort_initialize(aDataFrame, study_ID = TRUE,
  unscreenedValue = "not vetted", dual = FALSE, front = TRUE)
}
\arguments{
\item{aDataFrame}{A data.frame object that includes the titles and 
abstracts to be screened.  It will be formatted for screening efforts.  
See example: \code{\link{example_references_metagear}}}

\item{study_ID}{When \code{FALSE}, does not add a column "STUDY_ID" that
includes a unique identification number for each reference (row) in the
dataFrame.}

\item{unscreenedValue}{Changes the default coding (a string) of "not vetted"
that designates whether an abstract remains to be screened or vetted as
part of the "INCLUDE" column.}

\item{dual}{When \code{TRUE}, formats dataFrame for a dual screening (paired)
design.  Creates two reviewer teams: REVIEWERS_A and REVIEWERS_B.}

\item{front}{When \code{FALSE}, adds new columns to the back end of the
dataframe.  When \code{TRUE}, adds columns to the front.}
}
\value{
A data.frame formatted for title/abstract screening efforts.
}
\description{
Adds columns with standardized labels to a data framw with bibliographic data
on journal articles.  These columns will be used to assign reviewers, 
implementation of dual screening design, and the coding of
inclusion/exclusions screening decisions.
}
\examples{
data(example_references_metagear)
effort_initialize(example_references_metagear)        

}
\seealso{
\code{\link{effort_distribute}}, \code{\link{effort_merge}}, 
   \code{\link{effort_summary}}
}
