% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_barPlot.R
\name{figure_barPlot}
\alias{figure_barPlot}
\title{Detect and display all bar plot objects.}
\usage{
figure_barPlot(
  file = file.choose(),
  horizontal = FALSE,
  binary_threshold = 0.6,
  axis_thickness = 3,
  axis_sensitivity = 0.2,
  axis_length = 0.75,
  axis_X_color = "#00ABAB",
  axis_Y_color = "#B0D36A",
  Y_min = 0,
  Y_max = 100,
  bar_width = 9,
  bar_sensitivity = 0.1,
  point_color = "#0098B2",
  point_size = 9,
  ignore = FALSE
)
}
\arguments{
\item{file}{The file name and location of a bar-plot figure.  Prompts
for file name if none is explicitly called.}

\item{horizontal}{If \code{TRUE} then aims to detect objects from a bar-plot 
that depicts data horizontally (rather than vertically).}

\item{binary_threshold}{A proportion from zero to one designating the 
gray-scale threshold to convert pixels into black or white.  Pixel
intensities below the proportion will be converted to black, and those 
above white.}

\item{axis_thickness}{An integer used to designate the thickness of the 
axis lines on a figure.  Close alignment to the thickness of the axis
on a figure will improve axis detection.}

\item{axis_sensitivity}{A value designating the sensitivity of identifying 
straight lines on figure.  A smaller number results in a higher 
sensitivity to identify axes.}

\item{axis_length}{The relative size of the axis to the figure.  The default
is that axis lengths are 0.75 (75 percent) the size of the figure.  This 
option is necessary since bar lengths may be similar to the axis length.  
Values should range between zero and one.}

\item{axis_X_color}{The color to paint the detected X-axis.}

\item{axis_Y_color}{The color to paint the detected Y-axis.}

\item{Y_min}{The minimum Y value displayed on the Y-axis (used to scale
detected data points).}

\item{Y_max}{The maximum Y value displayed on the Y-axis (used to scale
detected data points).}

\item{bar_width}{An integer value designating the width of vertical lines on
bars.  A smaller number should be used when the width of bars are 
small (as well as the width of error bars).}

\item{bar_sensitivity}{A value designating the sensitivity of identifying 
the vertical lines on bars.  A smaller number should be used when the
thickness of bars are small (as well as the width of error bars).}

\item{point_color}{The color to paint the circles identifying the detected 
levels on bar columns and error bars.}

\item{point_size}{An integer used to designate the size of the points painting
the detected bars on a figure.}

\item{ignore}{When \code{TRUE} does not display painted image with detections,
only returns the data frame with detected points.}
}
\value{
A vector of scaled lengths for detected column and error bars.
}
\description{
Automated detection of grouped data displayed in a bar-plot/chart figure image.
The default returns these detected objects as an \code{EBImage} raster image, 
and as a vector of all the estimated lengths that are proportional to the values
presented on each bar (and their error bars, if they are present).  Note that
the extracted points will be sorted by their positioning on the X-axis (or 
Y if the plot is a horizontal bar plot).  For example, if there were error
bars in the figure these will be grouped with the detected bar column.  However,
within these X-axis positioning they will not be sorted.  See vignette for
worked several illustrations.
}
