% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_ref}
\alias{normalize_ref}
\title{Normalize intensities across samples using a reference feature}
\usage{
normalize_ref(
  data,
  reference_feature,
  identifier_column,
  reference_feature_intensity = 1
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{reference_feature}{An identifier for the reference feature. Must be unique. It is recommended to use the UID.}

\item{identifier_column}{The column in which to look for the reference feature. It is recommended to use \code{identifier_column = UID}}

\item{reference_feature_intensity}{Either a constant value with which the intensity of each feature is multiplied or a function (e.g., mean, median, min, max).
If a function is provided, it will use that function on the Intensities of the reference feature in all samples before normalization and multiply the intensity of each feature with that value after dividing by the Intensity of the reference feature.
For example, if \code{reference_feature_intensity = mean}, it calculates the mean of the Intensities of the reference features across samples before normalization. It then divides the Intensity of each feature by the Intensity of the reference feature in that sample.
Finally, it multiplies each Intensity with the mean of the Intensities of the reference features prior to normalization.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
Performs a normalization based on a reference feature, for example an internal standard.
Divides the Intensities of all features by the Intensity of the reference feature in that sample and multiplies them with a constant value, making the Intensity
of the reference feature the same in each sample.
}
\examples{
# Divide by the reference feature and make its Intensity 1000 in each sample
toy_metaboscape \%>\%
  impute_lod() \%>\%
  normalize_ref(reference_feature = 2, identifier_column = UID, reference_feature_intensity = 1000)

# Divide by the reference feature and make its Intensity the mean of intensities
# of the reference features before normalization
toy_metaboscape \%>\%
  impute_lod() \%>\%
  normalize_ref(reference_feature = 2, identifier_column = UID, reference_feature_intensity = mean)
}
