% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_auto}
\alias{scale_auto}
\title{Scale intensities of features using autoscale}
\usage{
scale_auto(data)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}
}
\value{
A tibble with autoscaled intensities.
}
\description{
Scales the intensities of all features using

\deqn{\widetilde{x}_{ij}=\frac{x_{ij}-\overline{x}_{i}}{s_i}}

where \eqn{\widetilde{x}_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} after scaling,
\eqn{x_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} before scaling, \eqn{\overline{x}_{i}} is the mean of intensities of feature \eqn{i} across all samples
and \eqn{{s_i}} is the standard deviation of intensities of feature \eqn{i} across all samples.
In other words, it subtracts the mean intensity of a feature across samples from the intensities of that feature in each sample and divides by the standard deviation of that feature.
For more information, see the reference section.
}
\examples{
toy_metaboscape \%>\%
  scale_auto()
}
\references{
\itemize{
\item R. A. Van Den Berg, H. C. Hoefsloot, J. A. Westerhuis, A. K. Smilde, M. J. Van Der Werf, \emph{BMC Genomics} \strong{2006}, \emph{7}, 142, DOI 10.1186/1471-2164-7-142.
}
}
