% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{categorical_data_frame}
\alias{categorical_data_frame}
\title{Categorical Function for Data Frame}
\usage{
categorical_data_frame(x, yvar = NULL, xvar, groups = NULL, facets = NULL,
  ylab = getOption("metaplot_lab", axislabel),
  xlab = getOption("metaplot_lab", axislabel),
  na.rm = getOption("metaplot_na.rm", TRUE),
  aspect = getOption("metaplot_aspect", 1),
  auto.key = getOption("metaplot_auto.key", NULL),
  keycols = getOption("metaplot_keycols", NULL),
  as.table = getOption("metaplot_categorical_as.table", TRUE),
  prepanel = getOption("metaplot_categorical_prepanel", function(...)
  list(xlim = 0:1, ylim = 0:1)),
  scales = getOption("metaplot_categorical_scales", NULL),
  panel = getOption("metaplot_categorical_panel", categorical_panel),
  colors = getOption("metaplot_colors", NULL),
  tiles = getOption("metaplot_tiles", 0.5),
  lines = getOption("metaplot_lines", TRUE),
  main = getOption("metaplot_main", NULL), sub = getOption("metaplot_sub",
  NULL), tex = getOption("metaplot_tex", 0.9),
  pch = getOption("metaplot_categorical_pch", 22),
  rot = getOption("metaplot_categorical_rot", c(90, 0)), subscripts = TRUE,
  par.settings = NULL, ...)
}
\arguments{
\item{x}{data.frame}

\item{yvar}{character: y variable (optional)}

\item{xvar}{character: x variable}

\item{groups}{optional grouping variable (can be missing)}

\item{facets}{optional conditioning variables}

\item{ylab}{y axis label; can be function(x = x, var = yvar, ..)}

\item{xlab}{x axis label; can be function(x = x, var = xvar, ..)}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{aspect}{passed to \code{\link[lattice]{xyplot}}}

\item{auto.key}{passed to \code{\link[lattice]{xyplot}}}

\item{keycols}{number of auto.key columns}

\item{as.table}{passed to \code{\link[lattice]{xyplot}}}

\item{prepanel}{passed to \code{\link[lattice]{xyplot}} (guessed if NULL)}

\item{scales}{passed to \code{\link[lattice]{xyplot}} (guessed if NULL)}

\item{panel}{name or definition of panel function}

\item{colors}{replacements for default colors in group order}

\item{tiles}{whether to fill rectangles for each group: logical, or alpha values between 0 and 1}

\item{lines}{whether to plot borders for each group: logical, or alpha values between 0 and 1}

\item{main}{character, or a function of x, yvar, xvar, groups, facets}

\item{sub}{character, or a function of x, yvar, xvar, groups, facets}

\item{tex}{tile expansion: scale factor for reducing each tile size relative to full size (<= 1)}

\item{pch}{symbol character for legend}

\item{rot}{rotation for axis labels; can be length 2 for y and x axes, respectively}

\item{subscripts}{passed to \code{\link[lattice]{xyplot}}}

\item{par.settings}{passed to \code{\link[lattice]{xyplot}} (calculated if null)}

\item{...}{passed to \code{\link{region}}}
}
\description{
Categorical function for class 'data.frame'. Default panel function implements a simple mosaic plot.
}
\examples{

library(magrittr)
library(dplyr)
library(csv)
x <- as.csv(system.file(package = 'metaplot', 'extdata/theoph.csv'))
x \%<>\% pack
x \%>\% metaplot(site)
x \%>\% metaplot(arm, site)
x \%>\% metaplot(arm, site, cohort)
x \%>\% metaplot(arm, site, , cohort)
x \%>\% metaplot(arm, site, , cohort, rot = c(0,90))
x \%>\% metaplot(arm, site, , cohort, rot = c(45, 45))
x \%>\% metaplot(subject,cohort,arm, site, lines = F, rot = c(45,45))
}
\seealso{
\code{\link{categorical_panel}}

Other categorical: \code{\link{categorical.data.frame}},
  \code{\link{categorical_panel}},
  \code{\link{categorical}}, \code{\link{panel_tile}}

Other metaplot: \code{\link{boxplot_data_frame}},
  \code{\link{corsplom_data_frame}},
  \code{\link{densplot_data_frame}},
  \code{\link{metaplot}}, \code{\link{scatter_data_frame}}
}
