% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{categorical_panel}
\alias{categorical_panel}
\title{Panel Function for Metaplot Categorical Plot}
\usage{
categorical_panel(x, y, groups, bivariate = TRUE,
  loc = metOption("loc_categorical_panel", 5),
  msg = metOption("msg_categorical_panel", "tilestats"),
  tex = metOption("tex_categorical_panel", 0.9),
  cex = metOption("cex_categorical_panel", 1),
  rot = metOption("rot_categorical_panel", c(90, 0)), subscripts,
  verbose = metOption("verbose_categorical_panel", FALSE), ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{groups}{optional grouping item}

\item{bivariate}{whether to create y axis}

\item{loc}{where to print statistics in a tile}

\item{msg}{a function of x and y to print text in a tile}

\item{tex}{tile expansion: scale factor for reducing each tile size relative to full size (<= 1)}

\item{cex}{expansion for msg text}

\item{rot}{rotation for axis labels; can be length 2 for y and x axes, respectively}

\item{subscripts}{subscripts of the original data for this panel}

\item{verbose}{generate messages describing process}

\item{...}{passed to \code{\link[lattice]{panel.superpose}}}
}
\description{
Default panel function for categorical_data_frame. Implements a simple mosaic plot.
Global options are supported but typically are supplied by the calling function and
may therefore be unreachable.
}
\seealso{
\code{\link{tilestats}}

\code{\link{categorical.data.frame}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{corsplom_gg_correlation}},
  \code{\link{corsplom_gg_diagonal}},
  \code{\link{corsplom_gg_scatter}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_diagonal}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_key}}, \code{\link{metaplot_ref}},
  \code{\link{panel.meta_densityplot}},
  \code{\link{panel_tile}},
  \code{\link{scatter_panel_ref}},
  \code{\link{scatter_panel}}

Other categorical: \code{\link{categorical.data.frame}},
  \code{\link{categorical_data_frame}},
  \code{\link{categorical}}, \code{\link{panel_tile}}
}
