% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{config_heatmap}
\alias{config_heatmap}
\title{Heatmap for visualizing an SNF config}
\usage{
config_heatmap(
  sc,
  order = NULL,
  hide_fixed = FALSE,
  show_column_names = TRUE,
  show_row_names = TRUE,
  rect_gp = grid::gpar(col = "black"),
  colour_breaks = c(0, 1),
  colours = c("black", "darkseagreen"),
  column_split_vector = NULL,
  row_split_vector = NULL,
  column_split = NULL,
  row_split = NULL,
  column_title = NULL,
  include_weights = TRUE,
  include_settings = TRUE,
  ...
)
}
\arguments{
\item{sc}{An \code{snf_config} class object.}

\item{order}{Numeric vector indicating row ordering of SNF config.}

\item{hide_fixed}{Whether fixed parameters should be removed.}

\item{show_column_names}{Whether show column names.}

\item{show_row_names}{Whether show row names.}

\item{rect_gp}{Graphic parameters for drawing rectangles (for heatmap body). The value should be specified by \code{\link[grid]{gpar}} and \code{fill} parameter is ignored.}

\item{colour_breaks}{Numeric vector of breaks for the legend.}

\item{colours}{Vector of colours to use for the heatmap. Should match the
length of colour_breaks.}

\item{column_split_vector}{Vector of indices to split columns by.}

\item{row_split_vector}{Vector of indices to split rows by.}

\item{column_split}{Split on columns. For heatmap splitting, please refer to \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#heatmap-split} .}

\item{row_split}{Same as \code{split}.}

\item{column_title}{Title on the column.}

\item{include_weights}{If TRUE, includes feature weights of the weights
matrix into the config heatmap.}

\item{include_settings}{If TRUE, includes columns from the settings data
frame into the config heatmap.}

\item{...}{Additional parameters passed to \code{ComplexHeatmap::Heatmap}.}
}
\value{
Returns a heatmap (class "Heatmap" from package ComplexHeatmap)
that displays the scaled values of the provided SNF config.
}
\description{
Create a heatmap where each row corresponds to a different set of
hyperparameters in an SNF config object. Numeric parameters are scaled
normalized and non-numeric parameters are added as heatmap annotations. Rows
can be reordered to match prior meta clustering results.
}
\examples{
dl <- data_list(
    list(income, "household_income", "demographics", "ordinal"),
    list(pubertal, "pubertal_status", "demographics", "continuous"),
    list(fav_colour, "favourite_colour", "demographics", "categorical"),
    list(anxiety, "anxiety", "behaviour", "ordinal"),
    list(depress, "depressed", "behaviour", "ordinal"),
    uid = "unique_id"
)

sc <- snf_config(
    dl,
    n_solutions = 10,
    dropout_dist = "uniform"
)

config_heatmap(sc)
}
