% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logLik.meteDist.R
\name{logLik.meteDist}
\alias{logLik.meteDist}
\title{Compute log-likelihood of a meteDist object}
\usage{
\method{logLik}{meteDist}(object, ...)
}
\arguments{
\item{object}{a \code{meteDist} object}

\item{...}{arguments to be passed}
}
\value{
object of class \code{logLik}
}
\description{
\code{logLik.meteDist} computes log-likelihood of a meteDist object
}
\details{
Degrees of freedom are assumed to be equal to the number of Lagrange
multpliers needed to specify the METE prediction. See Examples for usage.
}
\examples{
data(arth)
## object holding ecosystem structure function
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
## calculate individual power distribution and its likelihood
ipd1 <- ipd(esf1)
logLik(ipd1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology:
a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
sad, ssad, ipd, sipd
}

