% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.damuth.R
\name{plot.damuth}
\alias{plot.damuth}
\title{Plot the relationship between abundance and metabolic rate, i.e. objects of class damuth}
\usage{
\method{plot}{damuth}(x, add = FALSE, ...)
}
\arguments{
\item{x}{an object of class damuth}

\item{add}{logical; should new \code{damuth} object be added to current plot or made its own plot}

\item{...}{arguments passed to \code{plot}}
}
\description{
Plot abundance-metabolic rate relationship with flexibility to adjust plotting parameters
}
\details{
see examples
}
\examples{
data(arth)
esf1 <- meteESF(arth$spp, arth$count, arth$mass^0.75)
ebar1 <- ebar(esf1)
plot(ebar1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
empiricalSAR, downscaleSAR, upscaleSAR, meteSAR
}

