% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_reshape_meteo.R
\name{complete_meteo}
\alias{complete_meteo}
\title{Complete missing meteo variables}
\usage{
complete_meteo(meteo, verbose = getOption("meteoland_verbosity", TRUE))
}
\arguments{
\item{meteo}{meteoland meteo data}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}
}
\value{
the same \code{meteo} data provided with the the variables completed
}
\description{
Calculates missing meteo variables
}
\details{
This function takes a meteo object (with meteoland names) and complete any
missing variable if it is possible
}
\examples{

\donttest{
# example data
data("meteoland_meteo_example")

# remove MinRelativeHumidity
meteoland_meteo_example$MinRelativeHumidity <- NULL
# complete vars
completed_meteo <- complete_meteo(meteoland_meteo_example)
# check MinRelativeHumidity
completed_meteo$MinRelativeHumidity
}

}
