#' Reads WindNinja results
#'
#' @description
#' `r lifecycle::badge("deprecated")`
#'
#' Reads the wind fields generated by 'WindNinja'
#' (http://www.firelab.org/project/windninja) for combinations of domain-level
#' wind speed and wind direction classes.
#'
#'
#' @param filebase A string to indicate the template for accessing WindNinja
#' files. Resolution, wind directions and wind speed class values are appended
#' to this string to obtain the filename to read.
#' @param resolution Resolution string.
#' @param directionClasses A vector of wind speed directions (in degrees).
#' @param speedClasses A vector of wind class values (in m/s).
#' @param proj4string Object of class \code{"CRS"} with the projection string
#' of wind field rasters.
#' @return A list with the following items: \itemize{
#' \item\code{directionClasses}: The vector of wind direction classes.
#' \item\code{speedClasses}: The vector of wind speed classes.
#' \item\code{indexTable}: A numeric matrix indicating the raster index of each
#' combination of domain-level wind directions and wind speed classes.
#' \item\code{windSpeed}: An object of class \code{SpatialGridDataFrame}
#' containing wind speed rasters (in m/s) for each combination of domain-level
#' wind direction and wind speed.  \item\code{windDirection}: An object of
#' class \code{SpatialGridDataFrame} containing wind direction rasters
#' (in degrees from North) for each combination of domain-level wind direction
#' and wind speed. }
#' @note WindNinja should be run with m/s as wind speed units and for all the
#' combinations of domain-level wind speed and wind direction required.
#' @author Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
#' @seealso \code{\link{MeteorologyInterpolationData}}
#' @references Forthofer, J.M., Butler, B.W., Wagenbrenner, N.S., 2014. A
#' comparison of three approaches for simulating fine-scale surface winds in
#' support of wildland fire management. Part I. Model formulation and
#' comparison against measurements. Int. J. Wildl. Fire 23, 969–981.
#' @export
readWindNinjaWindFields<-function(filebase, resolution = "100m",
                                  directionClasses = c(0,45,90,135,180,225,270,315),
                                  speedClasses = c(5,15,25),
                                  proj4string = as.character(NA)) {

  lifecycle::deprecate_stop(
    when = "2.0.0", what = "readWindNinjaWindFields()", with = NULL,
    details = "readWindNinjaWindFields is deprecated"
  )

  # nraster = (8*length(speedClasses))
  # indexTable = matrix(1:nraster,
  #                      nrow=8, ncol=length(speedClasses),
  #                      dimnames=list(directionClasses, 1:length(speedClasses)))
  # firstfilename = paste(filebase,directionClasses[1],"_",speedClasses[1],"_",resolution,"_vel.asc",sep="")
  # a = read.asciigrid(firstfilename)
  # gt = getGridTopology(a)
  # ncells = nrow(a@data)
  # dfws = data.frame(matrix(0,nrow=ncells, ncol=nraster))
  # dfwd = data.frame(matrix(0,nrow=ncells, ncol=nraster))
  # names(dfws)<-1:nraster
  # names(dfwd)<-1:nraster
  # cnt = 0
  # for(j in 1:length(speedClasses)) {
  #   sc = speedClasses[j]
  #   for(i in 1:length(directionClasses)) {
  #     wd = directionClasses[i]
  #     cnt = cnt+1
  #     wsfilename = paste(filebase,wd,"_",sc,"_",resolution,"_vel.asc",sep="")
  #     wdfilename = paste(filebase,wd,"_",sc,"_",resolution,"_ang.asc",sep="")
  #     dfws[,cnt] = read.asciigrid(wsfilename)@data[,1]
  #     dfwd[,cnt] = read.asciigrid(wdfilename)@data[,1]
  #   }
  # }
  # windSpeed = SpatialGridDataFrame(gt, dfws, proj4string)
  # windDirection = SpatialGridDataFrame(gt, dfwd, proj4string)
  # l = list(directionClasses = directionClasses,
  #          speedClasses = speedClasses,
  #          indexTable = indexTable,
  #          windSpeed = windSpeed,
  #          windDirection = windDirection)
  # class(l)<-c("WindFields","list")
  # return(l)
}
