% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_interpolator.R
\name{read_interpolator}
\alias{read_interpolator}
\title{Read interpolator files}
\usage{
read_interpolator(filename)
}
\arguments{
\item{filename}{interpolator file name}
}
\value{
an interpolator (stars) object
}
\description{
Read interpolator files created with \code{\link{write_interpolator}}
}
\details{
This function takes the file name of the nc file storing an interpolator
object and load it into the work environment
}
\examples{

\donttest{
# example interpolator
data(meteoland_interpolator_example)

# temporal folder
tmp_dir <- tempdir()

# write interpolator
write_interpolator(
  meteoland_interpolator_example,
  file.path(tmp_dir, "meteoland_interpolator_example.nc")
)

# check file exists
file.exists(file.path(tmp_dir, "meteoland_interpolator_example.nc"))

# read it again
read_interpolator(file.path(tmp_dir, "meteoland_interpolator_example.nc"))
}

}
\seealso{
Other interpolator functions: \code{\link{add_topo}()},
\code{\link{create_meteo_interpolator}()},
\code{\link{get_interpolation_params}()},
\code{\link{set_interpolation_params}()}, \code{\link{with_meteo}()},
\code{\link{write_interpolator}()}
}
