% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_interpolator.R
\name{set_interpolation_params}
\alias{set_interpolation_params}
\title{Setting interpolation parameters in an interpolator object}
\usage{
set_interpolation_params(
  interpolator,
  params = NULL,
  verbose = getOption("meteoland_verbosity", TRUE)
)
}
\arguments{
\item{interpolator}{interpolator object to update}

\item{params}{list with the parameters provided by the user}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}
}
\value{
The same interpolator object provided, with the updated
interpolation parameters
}
\description{
Changing or updating interpolation parameters in an interpolator object
}
\details{
This function ensures that if no parameters are provided, the default ones
are used (see \code{\link{defaultInterpolationParams}}). Also, if params are
partially provided, this function ensures that the rest of the parameters
are not changed.
}
\examples{
# example interpolator
data(meteoland_interpolator_example)
# store the actual parameters
old_parameters <- get_interpolation_params(meteoland_interpolator_example)
# we can provide only the parameter we want to change
meteoland_interpolator_example <- set_interpolation_params(
  meteoland_interpolator_example,
  list(debug = TRUE)
)
# check
get_interpolation_params(meteoland_interpolator_example)$debug
# compare with old
old_parameters$debug
# the rest should be the same
setdiff(old_parameters, get_interpolation_params(meteoland_interpolator_example))

}
\seealso{
Other interpolator functions: \code{\link{add_topo}()},
\code{\link{create_meteo_interpolator}()},
\code{\link{get_interpolation_params}()}, \code{\link{read_interpolator}()},
\code{\link{with_meteo}()}, \code{\link{write_interpolator}()}
}
\author{
Victor Granda \enc{García}{Garcia}, EMF-CREAF
}
