% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_reshape_meteo.R
\name{worldmet2meteoland}
\alias{worldmet2meteoland}
\title{From worldmet to meteoland meteo objects}
\usage{
worldmet2meteoland(meteo, complete = FALSE)
}
\arguments{
\item{meteo}{worldmet meteo object.}

\item{complete}{logical indicating if the meteo data missing variables
should be calculated (if possible). Default to FALSE.}
}
\value{
a compatible meteo object to use with meteoland.
}
\description{
Adapting \code{\link[worldmet]{importNOAA}} meteo objects to meteoland meteo objects
}
\details{
This function converts \code{\link[worldmet]{importNOAA}} meteo objects to
compatible meteoland meteo objects by selecting the needed variables and
adapting the names to comply with meteoland requirements. Also it aggregates
subdaily data as well as complete missing variables if possible (setting
\code{complete = TRUE})
}
\examples{

if (interactive()) {
  # worldmet data
  library(worldmet)
  worldmet_stations <- worldmet::getMeta(lat = 42, lon = 0, n = 2, plot = FALSE)
  worldmet_subdaily_2022 <-
    worldmet::importNOAA(worldmet_stations$code, year = 2022, hourly = TRUE)

  # just convert
  worldmet2meteoland(worldmet_subdaily_2022)
  # convert and complete
  worldmet2meteoland(worldmet_subdaily_2022, complete = TRUE)

}

}
