% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSimulations.R
\name{runSimulations}
\alias{runSimulations}
\title{Run defined spatial simulations}
\usage{
runSimulations(simulations.input, simulations)
}
\arguments{
\item{simulations.input}{A prepared simulations.input object, as generated by 
prepSimulations.}

\item{simulations}{Optional list of named spatial simulation functions to use. These
must be defined in the defineSimulations function. If invoked, this option will likely
be used to run a subset of the defined spatial simulations.}
}
\value{
A list of lists of simulation results, where each of the first-order elements
in the list relates to a unique simulation as defined in defineSimulations.
}
\description{
Given a prepared simulations.input object, will run all simulations defined in 
defineSimulations, and return a list of randomized CDMs.
}
\details{
Currently we are running 3 spatial simulations. This function
first confirms that the input is of class simulations.input and, if so, then
confirms that the simulations are in a named list (via checkSimulations),
then lapplies all spatial simulation functions to the input object.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
competition.iterations=3)

#not run
results <- runSimulations(prepped)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

