% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepNulls.R
\name{prepNulls}
\alias{prepNulls}
\title{Prep data for null randomizations}
\usage{
prepNulls(tree, picante.cdm, regional.abundance = NULL,
  distances.among = NULL)
}
\arguments{
\item{tree}{Phylo object}

\item{picante.cdm}{A picante-style community data matrix with sites as rows, and
species as columns}

\item{regional.abundance}{A character vector in the form "s1, s1, s1, s2, s2, s3, etc".
Optional, will be generated from the input CDM if not provided.}

\item{distances.among}{An optional symmetric distance matrix describing the distances
among plots/etc, for use with null models like the dispersal null.}
}
\value{
A list of class nulls.input
}
\description{
Given a phylo object, a picante-style community data matrix (sites are rows,
species are columns), and an optional vector of regional abundance, prepare data for
randomizations.
}
\details{
Returns a named list with four elements: the original phylogenetic tree,
the original picante-style CDM, a spacodi-style CDM, and vector of regional abundance.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

prepped <- prepNulls(tree, cdm)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

