% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relativeCDM.R
\name{relativeCDM}
\alias{relativeCDM}
\title{Convert absolute abundance matrix to relative abundance}
\usage{
relativeCDM(picante.cdm, tree = NULL)
}
\arguments{
\item{picante.cdm}{Picante-style community data matrix with
communities/plots/plots/etc as rows and species as columns}

\item{tree}{Optional phylo object}
}
\value{
A relative abundance matrix otherwise identical to the input CDM.
}
\description{
Simple utility function to convert an absolute abundance matrix to a relative abundance
matrix.
}
\details{
This function converts species' absolute abundances in a given community (a
row in the input CDM) into relative abundances by dividing observed abundances by the
maximum abundance in that row. If a tree is provided, the function confirms that the
CDM is indeed in the correct format, otherwise it assumes it is formatted correctly
and proceeds accordingly.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

