% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_confusion_matrix.R
\name{confusion_matrix}
\alias{confusion_matrix}
\title{Confusion Matrix}
\usage{
confusion_matrix(
  data = NULL,
  obs,
  pred,
  plot = FALSE,
  unit = "count",
  colors = c(low = NULL, high = NULL),
  print_metrics = FALSE,
  metrics_list = c("accuracy", "precision", "recall"),
  position_metrics = "top",
  na.rm = TRUE
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character or factor).}

\item{pred}{Vector with predicted values (character or factor).}

\item{plot}{Logical operator (TRUE/FALSE) that controls the output as a
\code{data.frame} (plot = FALSE) or as a plot of type \code{ggplot} (plot = TRUE), Default: FALSE}

\item{unit}{String (text) indicating the type of unit ("count" or "proportion")
to show in the confusion matrix, Default: 'count'}

\item{colors}{Vector or list with two colors indicating how to paint the gradient
between "low" and "high", Default: c(low = NULL, high = NULL) uses the standard
blue gradient of ggplot2.}

\item{print_metrics}{boolean TRUE/FALSE to embed metrics in the plot. Default is FALSE.}

\item{metrics_list}{vector or list of selected metrics to print on the plot.
Default: c("accuracy", "precision", "recall").}

\item{position_metrics}{string specifying the position to print the performance
\code{metrics_list}. Options are "top" (as a subtitle) or "bottom" (as a caption).
Default: "bottom".}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
An object of class \code{data.frame} when plot = FALSE, or of type \code{ggplot}
when plot = TRUE.
}
\description{
It creates a confusion matrix table or plot displaying the agreement
between the observed and the predicted classes by the model.
}
\details{
A confusion matrix is a method for summarizing the predictive performance of a classification algorithm.
It is particularly useful if you have an unbalanced number of observations belonging to each class or if you have
a multinomial dataset (more than two classes in your dataset. A confusion matrix can give you a good hint about
the types of errors that your model is making.
See \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(183)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE),
predictions = sample(c("True","False"), 100, replace = TRUE))
# Multi-class
multinomial_case <- data.frame(labels = sample(c("Red","Blue", "Green"), 100,
replace = TRUE), predictions = sample(c("Red","Blue", "Green"), 100, replace = TRUE))

# Plot two-class confusion matrix
confusion_matrix(data = binomial_case, obs = labels, pred = predictions, 
plot = TRUE, colors = c(low="pink" , high="steelblue"), unit = "count")

# Plot multi-class confusion matrix
confusion_matrix(data = multinomial_case, obs = labels, pred = predictions, 
plot = TRUE, colors = c(low="#f9dbbd" , high="#735d78"), unit = "count")
}
}
\references{
Ting K.M. (2017).
Confusion Matrix. \emph{In: Sammut C., Webb G.I. (eds) Encyclopedia of Machine Learning and Data Mining.}
\emph{Springer, Boston, MA.} \doi{10.1007/978-1-4899-7687-1_50}
}
\seealso{
\code{\link[rlang]{eval_tidy}}, \code{\link[rlang]{defusing-advanced}}
\code{\link[dplyr]{select}}
}
