\name{NONR}
\alias{NONR}
\alias{NONR72}
\title{Run NONMEM}
\description{
\code{NONR} executes, from R, a NONMEM run for which there exists a compatible (see note)
  control stream. Supported platforms include MS Windows and 
  Unix-like operating systems (Nix).  Special support is included for Sun Grid
  Engine with Nix.  Generally, NONMEM needs to be installed using NMQual
  (http://nmqual.googlecode.com).  Execution on the Nix grid requires
  the installation of Sun Grid Engine v6.  Following a successful NONMEM
  run \code{NONR} can call \code{PLOTR} to create diagnostic plots (pdf format) and/or
  run a user-written script. \code{NONR72} is a wrapper designed to invoke an 
  NMQual-mediated installation of NONMEM 7.2.0 or above.  See \code{\link{autolog.pl}}.
}
\usage{
NONR(
	run, 
	command, 
	project = getwd(), 
	wait = TRUE,
	grid = FALSE, 
	concurrent = grid & wait,
	udef= FALSE, 
	invisible=udef,
	compile = TRUE,
	execute = TRUE,
	split = grid & compile & execute,
	checkrunno = TRUE, 
	checksum = TRUE, 
	diag = wait, 
	fdata = TRUE, 
	logtrans = FALSE,
	nice= TRUE, 
	epilog = NULL, 
	dvname = NULL, 
	grp = NULL, 
	grpnames = NULL, 
	cont.cov = NULL, 
	cat.cov = NULL, 
	par.list = NULL, 
	eta.list = NULL, 
	missing = -99, 

	...
)
NONR72(
	run, 
	command, 
	project = getwd(), 
	wait = TRUE,
	grid = FALSE, 
	concurrent = grid & wait,
	udef= FALSE, 
	invisible=udef,
	compile = TRUE,
	execute = TRUE,
	split = FALSE,
	checkrunno = TRUE, 
	checksum = TRUE, 
	diag = wait, 
	fdata = TRUE, 
	logtrans = FALSE,
	nice= TRUE, 
	epilog = NULL, 
	dvname = NULL, 
	grp = NULL, 
	grpnames = NULL, 
	cont.cov = NULL, 
	cat.cov = NULL, 
	par.list = NULL, 
	eta.list = NULL, 
	missing = -99, 
	...,
	interface='autolog.pl',
	q='all.q'
)
}

\arguments{

  \item{run}{
  vector of control stream names.  Typically integer.
  e.g. 1:10 corresponds to 1.ctl, 2.ctl, ... 10.ctl.
 } 

  \item{command}{
  path for a script to run NONMEM, e.g., 
  \code{command='C:/nm6/test/nm6.pl'}.  The script is assumed to be an NMQual-generated
  wrapper for NONMEM execution, but may also be arbitrarily defined by the user
  (\code{udef=TRUE}).  In the former case, appropriate arguments and modifiers are added
  to build a typical NMQual commandline (\code{nm.pl} or \code{autolog.pl}), conditionally wrapped in the arguments for
  a typical grid commandline (\code{qsub}).  The path may be given relative to the 
  current directory.  \code{command} may be a character vector of length greater than one: 
  each element will be run in succession.
  
  If \code{command} is missing, an attempt will be made to locate a NONMEM installation 
  using \code{\link{findNonmemCommand}} (as of package version 5.15).  DISCLAIMER: it is the responsibility
  of the user to ensure that the command thus-identified is appropriate.
 } 

  \item{project}{
  directory in which run-specific subdirectories will be created. 
  Typically also contains original control streams.
  Use an absolute path (safer) or specify relative to the current working directory.
 }

  \item{wait}{
  If \code{wait} is \code{FALSE} (e.g. for large batches of simulations or bootstraps) and 
  \code{grid} is \code{TRUE}, the job will run asynchronously and no
  cleanup or plotting will be attempted.  Default \code{TRUE}, gives 
  synchronous runs on the grid, but these are usually limited in number.  
  New in version 5.22 (replaces \code{boot}).  \code{wait} also controls the defaults
  for \code{diag} and \code{sync}): see \link{runNonmem}.
 } 
  
  \item{grid}{
  whether NONMEM execution should be wrapped in a call to Sun Grid Engine's 
  \code{qsub} utility.  \code{FALSE} by default.  Set to \code{TRUE}
  explicitly for regular runs using a grid.  Coerced to \code{FALSE} for Windows.}  
  %Autogenerated run directories will end in \file{.lock} until run is complete.
  
  \item{concurrent}{
  Should the runs represented by elements of \code{run} be run 
  concurrently as separate processes?  Normally \code{TRUE} if \code{grid} is 
  \code{TRUE}, since this is the primary advantage of using a grid.
  Coerced to \code{FALSE} on Windows.  Concurrency is implemented using the package \pkg{fork}.
  
  As of version 5.22, this argument defaults to \code{TRUE} only for regular
  runs on the grid. Unsynchronized (\code{wait} is \code{FALSE}) runs on the grid return control to the console 
  almost immediately (\code{sync='n'}) so there is little advantage for each
  run to have its own process.
 }
  
  %\item{urgent}{
  %Should jobs use as many resources as possible?  Only meaningful
  %in the grid environment, where all available processors will be 
  %used if urgent, and a limited number of processors if not.  In
  %practice, this dissolves to a choice between \code{q='all.q'} and 
  %\code{q='bootstrap.q'}.  Passing \code{q} explicitly will override this choice.
 %}

  \item{udef}{a logical indicating whether \code{command} is user defined.  If so, the 
  \code{command} is simply wrapped in a system call rather than pre-converted to a 
  (possibly grid-ready) NMQual commandline. Default: \code{FALSE}} 
  
  \item{invisible}{\code{intern}, \code{minimized}, and \code{invisible} 
  	  can be specified for the system call that runs NONMEM.  \pkg{metrumrg}
  will largely ignore these on a unix-like platform.  For Windows, \code{invisible} is
  \code{TRUE} by default when \code{udef} is \code{TRUE}, and \code{FALSE} otherwise.  If \code{FALSE}, 
  NONMEM output will be displayed in a command window during the run.  Set 
  \code{invisible=TRUE} to suppress this display.  See the Windows help for
  \code{system}.  To explore interactively, use \code{debug(runCommand)}.} 

  \item{compile}{whether to compile NONMEM (i.e., make nonmem.exe).  Set to \code{FALSE}
  if you already did this in a previous step and merely want to execute.}

  \item{execute}{whether to execute the compiled NONMEM (i.e., invoke nonmem.exe).
  Set to \code{FALSE} if you merely want to compile, e.g. to verify compile success without
  committing to a run.  You can run the compiled object later with \code{compile=FALSE}.}

  \item{split}{whether to compile and execute as separate steps.  If both
  compile and execute are \code{TRUE}, the run can be split into two separate steps (this 
  is the default if grid is \code{TRUE}.  Though \code{split}, \code{compile}, and 
  \code{execute} can be manipulated independently, it makes no sense to split a run
  unless \code{compile} and \code{execute} are both \code{TRUE}.  The greatest advantage
  to splitting is realized on a grid, with \code{grid=TRUE}: runs will be split
  and compile steps will by default be run in their own queue, for efficiency.}

  \item{checkrunno}{whether to check/correct the control stream to
  ensure that standard uses of the NONMEM control stream name match the
  name listed in \code{run} vector. Default: \code{TRUE}.  For files, e.g.
  \code{../3.TAB}, path separator  must be that recognized by \code{dirname} and \code{basename}.
  Only one usage per line of text will be fixed.
  
  \sQuote{Standard} uses currently include:  the first word after $PROB(LEM) (not 
  counting RUN or RUN\#); \file{*.tab} (case insensitive); \file{*par.tab} (case insensitive);
  \file{*.msf} (case insensitive) except on a line that starts with $MSFI.  
 }  
  
  \item{checksum}{If \code{TRUE} (default), checksums are requested from \code{nm.pl} when 
  wrapping NONMEM execution.  \code{FALSE} is useful for development.} 

  \item{diag}{whether to plot standard diagnostic plots. Default: \code{TRUE} for 
  synchronized runs. You can override the default file name by passing 
  \code{plotfile}.  See \code{\link{PLOTR}} for details. Also see Note below for
  required control stream syntax, e.g. expected tables.}
 
  \item{fdata}{whether to attempt deletion of NONMEM files FDATA and
  PRDERR. Default: \code{TRUE}.}  
  
  \item{logtrans}{passed to PLOTR}     

  \item{nice}{whether the NONMEM run directory, based on \code{run}, is
  deleted or simply emptied prior to the execution of NONMEM. If
  \code{nice=TRUE} (default), hidden files (as defined for \code{all.files} in 
  the function \code{dir}) are not deleted, e.g., any \code{.svn} directory.} 

  \item{epilog}{
  user-defined function or script to call at end of NONR or PLOTR.
  A non-null argument that cannot be coerced by \code{match.fun} to a function
  will be treated as a filename to be sourced.  All the arguments normally
  available to \code{PLOTR} (\code{run, project, dvname, logtrans, grp, grpnames, cont.cov, 
  at.cov, par.list, eta.list, missing}, etc) will be available to \code{epilog}, as well
  as any extra arguments you pass to \code{NONR} or \code{PLOTR}. A
  function can declare any of these, but should at minimum contain the 
  \dots argument. A script can expect them to be present.  See also 
  \file{inst/example/epilog.R} in this package.  To see exactly what is available,
  try \code{epilog=function(...)cat(names(list(...)))}.
 }  
  
  \item{dvname}{name of the dependent variable to use as a label for the diagnostic plots. Default: DV.}
  
  \item{grp}{passed to \code{PLOTR}} 
  \item{grpnames}{passed to \code{PLOTR}}
  \item{cont.cov}{passed to \code{PLOTR}}
  \item{cat.cov}{passed to \code{PLOTR}} 
  \item{par.list}{passed to \code{PLOTR}}
  \item{eta.list}{passed to \code{PLOTR}}
  \item{missing}{passed to \code{PLOTR}}
  \item{interface}{the name of a function to prepare NONMEM command lines}
  \item{q}{choice of queue, passed to \code{qsub}}
  \item{\dots}{additional arguments passed to functions that accept them. For example,
  you can pass \code{onefile=FALSE} to \code{pdf}, called by \code{PLOTR}.  You can also pass
  additional lattice arguments to modify the diagnostic plots.  You can gain finer control
  of run behavior by modifying arguments to \code{\link{runNonmem}}, e.g. \code{purge=FALSE}.
  
  Flags recognized
  by Sun Grid Engine's \code{qsub} are accepted by a like-named wrapper (this effect replaces
  the older SGEflgs argument).  Example: to set a maximum run length of one hour and get an email 
  if the run goes over one hour and is killed, include \code{l='h_rt=1:0:0',
  m='e',M='name@email.address'}. Passing N, o, e, V, j, q, sync, shell, b, or cwd
  will override defaults.  You can pass multiple instances of an argument if \code{qsub} 
  allows it.  passing L will override a constitutive instance of l in \code{runCommand}.
  Values are character vectors.  Lengths greater than one result in element-wise
  paste operations: a vector of corresponding length will be returned.}
  
}
\details{
	\code{NONR} is currently implemented as a wrapper that calls \code{runNonmem} for each
element in \code{run}.  It creates a like-named subdirectory for each
run in \code{project}. It looks for \code{<run>.ctl} in \code{project},
cleans it up as necessary, and writes it to the subdirectory, in which context
NONMEM is invoked (using \code{runCommand}).  The output of NONMEM will be 
\file{<run>.lst} in the subdirectory.  Files matching patterns in \code{purgeRunDir:standard} will
be removed. Attempts will be made to run \code{PLOTR} and \code{epilog}.  
Then a \sQuote{complete} message is printed.

As of version 5.22, parallelization is directly supported.
\code{<run>.pnm} is copied to the subdirectory, if present in the
same directory as \code{<run>.ctl}. If not, \code{template.pnm} is copied to the subdirectory 
(if present in the same directory as \code{<run>.ctl}) and is renamed \code{<run>.ctl}.
Use an NMQual-mediated NONMEM installation that expects this convention.

File names and locations can be manipulated somewhat, i.e., by over-riding
\code{runNonmem}'s defaults for \code{rundir}, \code{outfile}, \code{streams}, 
\code{ctlfile}, and \code{remove}.
}

\value{an invisible list of the results of calls to \code{\link{runNonmem}}}
\note{
  Specific control stream syntax is expected
  when running \code{NONR} and the other functions present in the \pkg{metrumrg} package.
  The list of syntax requirements are as follows.
  \itemize{
 
  \item $PROB should be followed by \sQuote{RUN\#} then a number representing 
  the control stream number. No commas should be used in the $PROB statement.
  \sQuote{PROBLEM} is an alternative for \sQuote{PROB}.  The run number is the first space-delimited
  alphanumeric sequence after PROB(LEM), ignoring RUN(\#).  No ampersands are allowed in the problem statement.

  \item The datafile name and relative path needs to be on the first line of the
  $DATA record immediately following \sQuote{$DATA}.
  
  \item A relative datafile path must be specified relative to \code{runNonmem:rundir}, typically a subdirectory
  of \code{project}.  For example, \file{3.ctl} will actually run as \file{path/project/3/3.ctl}; if
  its datafile is \file{path/data/DATA3}, then 3.ctl should specify 
  \dQuote{$DATA ../../data/DATA3}.
  
  \item The NONMEM datafile must contain a \sQuote{C} column
  containing only C's or periods(\sQuote{.}).  Typically this is the first column.
  
  \item The \file{*.TAB} file in the \dQuote{$TABLE}
  step must contain an EVID column for plotting purposes. In the case
  of \dQuote{$PRED} models, this can be a dummy column in the data file.
  
  \item The NONMEM data file must contain a column with a header of \sQuote{ID} for
  plotting purposes.
  
  \item File paths for \file{MSF} files and \file{TAB} files, etc., are generally expected to 
  be relative paths, using \sQuote{/} as the directory separator.  File paths with no
  separator are assumed to be relative to the directory in which the control
  stream is run: \sQuote{./} may be prepended.  E.g. \dQuote{$TABLE EVID FILE=100.tab} is taken
  as \dQuote{$TABLE EVID FILE=./100.tab}.
  
  \item $TABLE statments should include the ONEHEADER option, or problems may result.
  
  \item Avoid the use of ampersands and greater-than, less-than symbols in comments: they confuse xml processors.
 }

  \code{PLOTR} will automatically generate CWRES plots if required files are
 present in NONMEM run directory. See help for \code{compute.cwres} for
 instructions on generating the files required for CWRES plots.  \code{PLOTR}
 expects etas and model parameters to be output in the \file{*par.TAB} file and
 variables for diagnostic plots to be output in the \file{*.TAB} file, where
 \sQuote{*} represents the control stream number.  Additional $TABLE records
 can be present in the control stream but these are not used/needed by
 \code{PLOTR}.  Mechanisms and expectations are somewhat different for NONMEM7.
}

 \references{\url{http://metrumrg.googlecode.com}}
 \author{written by Bill Knebel; modified by Tim Bergsma.}
\seealso{
	\itemize{
		\item \code{\link{runNonmem}}
		\item \code{\link{PLOTR}}
	}
}
\examples{
metrumrgURL('example/project/script/model.pdf')
\dontrun{
#Assuming an NMQual-mediated NONMEM wrapper: /opt/NONMEM/nm72/nmqual/autolog.pl
#Assuming this is some script directory, and contol streams (e.g. 1.ctl) are in a sibling directory "nonmem"

#regular run, no grid
path <- '/opt/NONMEM/nm72/nmqual/autolog.pl'
NONR72(
	run=1,
	command=path,
	project='../nonmem',
	wait=TRUE,                 #default
	grid=FALSE,                #default
	diag=TRUE                  #default
)

#regular run on grid
NONR72(
	run=1,
	command=path,
	project='../nonmem',
	wait=TRUE,                 #default
	grid=TRUE,
	diag=TRUE                  #default
)

#bootstrap run, no grid (uncommon)
NONR72(
	run=1,
	command=path,
	project='../nonmem',
	wait=FALSE,                 
	grid=FALSE,                #default
	diag=FALSE                 #default
)

#bootstrap run on grid
NONR72(
	run=1,
	command=path,
	project='../nonmem',
	wait=FALSE,
	grid=TRUE,
	diag=FALSE                 #default
)
}
}
\keyword{manip}

