% Generated by roxygen2 (4.0.1): do not edit by hand
\name{summary.cor}
\alias{summary.cor}
\title{Summary for dependence models for competing risks}
\usage{
\method{summary}{cor}(object, marg.cif = NULL, marg.cif2 = NULL,
  digits = 3, ...)
}
\arguments{
\item{object}{object from cor.cif rr.cif or or.cif for dependence between competing risks data for two causes.}

\item{marg.cif}{a number that gives the cumulative incidence in one time point for which concordance and
probandwise concordance are computed.}

\item{marg.cif2}{the cumulative incidence for cause 2 for concordance and
probandwise concordance are computed. Default is that it is the same as marg.cif.}

\item{digits}{digits in output.}

\item{...}{Additional arguments.}
}
\value{
prints summary for dependence model.
\item{probandwise}{gives probandwise concordance that is, probability of cause 2 (related to cif2) given that cause 1 (related to cif1)
	has occured.}
\item{concordance}{gives concordance that is, probability of cause 2 (related to cif2) and cause 1 (related to cif1).}
\item{cif1}{cumulative incidence for cause1.}
\item{cif2}{cumulative incidence for cause1.}
}
\description{
Computes concordance and probandwise concordance for dependence models for competing risks
models of the type cor.cif, rr.cif or or.cif for the given cumulative incidences and the different dependence
measures in the object.
}
\examples{
data(multcif) # simulated data
multcif$cause[multcif$cause==0] <- 2

times=seq(0.05,3,by=0.1) # to speed up computations use only these time-points
add<-comp.risk(Event(time,cause)~const(X)+cluster(id),data=multcif,
               n.sim=0,times=times,cause=1)
###
out1<-cor.cif(add,data=multcif,cause1=1,cause2=1,theta=log(2+1))
summary(out1)

pad <- predict(add,X=1,Z=0,se=0,uniform=0)$P1
summary(out1,marg.cif=pad)
}
\author{
Thomas Scheike
}
\references{
Cross odds ratio Modelling of dependence for
Multivariate Competing Risks Data, Scheike and Sun (2012), Biostatistics to appear.

A Semiparametric Random Effects Model for Multivariate Competing Risks Data,
Scheike, Zhang, Sun, Jensen (2010), Biometrika.
}
\keyword{survival}

