% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecourse.R
\name{lifecourse}
\alias{lifecourse}
\title{Life-course plot}
\usage{
lifecourse(formula, data, id = "id", group = NULL, type = "l", lty = 1,
  col = 1:10, alpha = 0.3, lwd = 1, recurrent.col = NULL,
  legend = NULL, by = NULL, status.legend = NULL,
  place.sl = "bottomright", xlab = "Time", ylab = "", add = FALSE, ...)
}
\arguments{
\item{formula}{Formula (Event(start,slut,status) ~ ...)}

\item{data}{data.frame}

\item{id}{Id variable}

\item{group}{group variable}

\item{type}{Type (line 'l', stair 's', ...)}

\item{lty}{Line type}

\item{col}{Colour}

\item{alpha}{transparency (0-1)}

\item{lwd}{Line width}

\item{recurrent.col}{col of recurrence type}

\item{legend}{position of optional id legend}

\item{by}{make separate plot for each level in 'by' (formula, name of column, or vector)}

\item{status.legend}{Status legend}

\item{place.sl}{Placement of status legend}

\item{xlab}{Label of X-axis}

\item{ylab}{Label of Y-axis}

\item{add}{Add to existing device}

\item{...}{Additional arguments to lower level arguments}
}
\description{
Life-course plot for event life data with recurrent events
}
\examples{
data = data.frame(id=c(1,1,1,2,2),start=c(0,1,2,3,4),slut=c(1,2,4,4,7),
                  type=c(1,2,3,2,3),status=c(0,1,2,1,2),group=c(1,1,1,2,2))
ll = lifecourse(Event(start,slut,status)~id,data,id="id")
ll = lifecourse(Event(start,slut,status)~id,data,id="id",recurrent.col="type")

ll = lifecourse(Event(start,slut,status)~id,data,id="id",group=~group,col=1:2)
op <- par(mfrow=c(1,2))
ll = lifecourse(Event(start,slut,status)~id,data,id="id",by=~group)
par(op)
legends=c("censored","pregnant","married")
ll = lifecourse(Event(start,slut,status)~id,data,id="id",group=~group,col=1:2,status.legend=legends)

}
\author{
Thomas Scheike Klaus K. Holst
}
