% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casewise.R
\name{binregCasewise}
\alias{binregCasewise}
\title{Estimates the casewise concordance based on Concordance and marginal estimate using binreg}
\usage{
binregCasewise(concbreg, margbreg, zygs = c("DZ", "MZ"), newdata = NULL, ...)
}
\arguments{
\item{concbreg}{Concordance}

\item{margbreg}{Marginal estimate}

\item{zygs}{order of zygosity for estimation of concordance and casewise.}

\item{newdata}{to give instead of zygs.}

\item{...}{to pass to estimate function}
}
\description{
Estimates the casewise concordance based on Concordance and marginal estimate using binreg
}
\details{
Uses cluster iid for the two binomial-regression estimates  standard errors better than those of casewise that are often conservative.
}
\examples{
data(prt)
prt <- force.same.cens(prt,cause="status")

dd <- bicompriskData(Event(time, status)~strata(zyg)+id(id), data=prt, cause=c(2, 2))
newdata <- data.frame(zyg=c("DZ","MZ"),id=1)

## concordance 
bcif1 <- binreg(Event(time,status)~-1+factor(zyg)+cluster(id), data=dd,
                time=80, cause=1, cens.model=~strata(zyg))
pconc <- predict(bcif1,newdata)

## marginal estimates 
mbcif1 <- binreg(Event(time,status)~cluster(id), data=prt, time=80, cause=2)
mc <- predict(mbcif1,newdata)
mc

cse <- binregCasewise(bcif1,mbcif1)
cse
}
\author{
Thomas Scheike
}
