% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivar.R
\name{chibar}
\alias{chibar}
\title{Parametric estimates of \eqn{\bar{\chi}}{chi bar}}
\usage{
chibar(dat, confint = c("delta", "profile", "tem"), qu = 0, level = 0.95)
}
\arguments{
\item{dat}{an \eqn{n} by \eqn{d} matrix of multivariate observations}

\item{confint}{string indicating the type of confidence interval.}

\item{qu}{percentile level at which to threshold. Default to all observations.}

\item{level}{the confidence level required}
}
\value{
a named vector of length 3 containing the point estimate, the lower and the upper confidence intervals
}
\description{
The function fits a generalized Pareto distribution to minima of Pareto variates,
using the representation \deqn{\Pr(\min(X) > x) = \frac{L(x)}{x^{1/\eta}},}
where \eqn{\bar{\chi}=2\eta-1}. The data are transformed to the unit Pareto scale and
a generalized Pareto variable is fitted to the minimum. The parameter \eqn{\eta} corresponds to the shape of the latter.
The confidence intervals can be based either on the delta-method, a profile likelihood or a tangent exponential model approximation.
}
\examples{
\dontrun{
set.seed(765)
# Max-stable model, chibar = 1
dat <- evd::rbvevd(n = 1000, dep = 0.5)
chibar(dat, 'profile', qu = 0.5)
s <- seq(0.05,1, length = 30)
chibar_est <- t(sapply(s, function(keep){chibar(dat, 'delta', qu = keep)}))
matplot(s, chibar_est, type = 'l', col = c(1, 2, 2),  lty = c(1, 2, 2),
 ylab = expression(bar(chi)), xlab = 'p')
abline(h = 1, lty = 3, col = 'grey')
# Multivariate normal sample, chibar = 0 - strong asymptotic independence at penultimate level
dat <- mvrnorm(n = 1000, mu = c(0, 0), Sigma = cbind(c(1, 0.75), c(0.75, 1)))
chibar(dat, 'tem', q = 0.1)
chibar_est <- t(sapply(s, function(keep){chibar(dat, 'profile', qu = keep)}))
matplot(s, chibar_est, type = 'l', col = c(1, 2, 2),  lty = c(1, 2, 2),
 ylab = expression(bar(chi)), xlab = 'p')
abline(h = 1, lty = 3, col = 'grey')
}
}
\seealso{
\code{\link[evd]{chiplot}} for empirical estimates of \eqn{\chi}{chi} and \eqn{\bar{\chi}}{chibar}.
}
\keyword{internal}
