% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.rdirspec}
\alias{.rdirspec}
\title{Generates from \eqn{Q_i}{Qi}, the spectral measure of the extremal Dirichlet
model}
\usage{
.rdirspec(n, d, alpha, irv = FALSE)
}
\arguments{
\item{n}{sample size}

\item{d}{dimension of sample}

\item{alpha}{vector of Dirichlet parameters of dimension \code{d}, or \eqn{d+1} vector with the \code{d} Dirichlet parameters and an index of regular variation in \eqn{[0, 1]}}

\item{irv}{should the usual model (\code{FALSE}) or the general scaled version (\code{TRUE}) be used}

\item{rho}{index of regular variation}
}
\value{
an \code{n} by \code{d} sample from the spectral distribution
}
\description{
This model was introduced in Coles and Tawn (1991); the
present method uses the simulation algorithm of Boldi (2009) for the extremal Dirichlet model
}
\references{
Boldi (2009). A note on the representation of parametric models
for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
}
\keyword{internal}
