% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefvariation.R
\name{cvselect}
\alias{cvselect}
\title{Threshold selection via coefficient of variation}
\usage{
cvselect(
  xdat,
  thresh,
  method = c("mle", "wcv", "cv"),
  nsim = 999L,
  nthresh = 10L,
  level = 0.05,
  lazy = FALSE
)
}
\arguments{
\item{xdat}{[vector] vector of observations}

\item{thresh}{[vector] vector of threshold. If missing, set to \eqn{p^k} for \eqn{k=0} to \eqn{k=}\code{nthresh}}

\item{method}{[string], either moment estimator for the (weighted) coefficient of variation (\code{wcv} and \code{cv}) or maximum likelihood (\code{mle})}

\item{nsim}{[integer] number of bootstrap replications}

\item{nthresh}{[integer] number of thresholds, if \code{thresh} is not supplied by the user}

\item{level}{[numeric] probability level for sequential testing procedure}

\item{lazy}{[logical] compute the bootstrap p-value until the test stops rejecting at level \code{level}? Default to \code{FALSE}}
}
\value{
a list with elements
\itemize{
\item{thresh}{value of threshold returned by the procedure, \code{NA} if the hypothesis is rejected at all thresholds}
\item{cthresh}{sorted vector of candidate thresholds}
\item{cindex}{index of selected threshold among \code{cthresh} or \code{NA} if none returned}
\item{pval}{bootstrap p-values, with \code{NA} if \code{lazy} and the p-value exceeds level at lower thresholds}
\item{shape}{shape parameter estimates}
\item{nexc}{number of exceedances of each threshold \code{cthresh}}
\item{method}{estimation method for the shape parameter}
}
}
\description{
This function computes the empirical coefficient of variation and
computes a weighted statistic comparing the squared distance with
the theoretical coefficient variation corresponding to a specific
shape parameter (estimated from the data using a moment estimator
as the value minimizing the test statistic, or using maximum likelihood).
The procedure stops if there are no more than 10 exceedances above the
highest threshold
}
\references{
del Castillo, J. and M. Padilla (2016). \emph{Modelling extreme values by the residual coefficient of variation}, SORT, 40(\bold{2}), pp. 303--320.
}
