% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egp.R
\name{egp2.fit}
\alias{egp2.fit}
\title{Fit an extended generalized Pareto distribution of Naveau et al.}
\usage{
egp2.fit(
  data,
  model = 1,
  method = c("mle", "pwm"),
  init,
  censoring = c(0, Inf),
  rounded = 0,
  CI = FALSE,
  R = 1000,
  ncpus = 1,
  plots = TRUE
)
}
\arguments{
\item{data}{data vector.}

\item{model}{integer ranging from 0 to 4 indicating the model to select (see \code{\link{extgp}}).}

\item{method}{string; either \code{'mle'} for maximum likelihood, or \code{'pwm'} for probability weighted moments, or both.}

\item{init}{vector of initial values, comprising of \eqn{p}, \eqn{\kappa}, \eqn{\delta},\eqn{\sigma},\eqn{\xi} (in that order) for the optimization. All parameters may not appear depending on \code{model}.}

\item{censoring}{numeric vector of length 2 containing the lower and upper bound for censoring; \code{censoring=c(0,Inf)} is equivalent to no censoring.}

\item{rounded}{numeric giving the instrumental precision (and rounding of the data), with default of 0.}

\item{R}{integer; number of bootstrap replications.}

\item{ncpus}{integer; number of CPUs for parallel calculations (default: 1).}

\item{plots}{logical; whether to produce histogram and density plots.}
}
\description{
Deprecated function name to fit an extended generalized Pareto family. The user should call \code{\link[mev]{fit.extgp}} instead.
}
\seealso{
\code{\link[mev]{fit.extgp}}
}
\keyword{internal}
