% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xdep.R
\name{xdep.eta}
\alias{xdep.eta}
\title{Coefficient of tail dependence}
\usage{
xdep.eta(
  xdat,
  qlev = NULL,
  nq = 40,
  qlim = c(0.8, 0.99),
  estimator = c("emp", "betacop", "gpd", "hill", "kj"),
  confint = c("wald", "lrt"),
  level = 0.95,
  margtrans = c("emp", "sp", "none"),
  ties.method = "random",
  plot = TRUE,
  mqlev = NULL,
  ...
)
}
\arguments{
\item{xdat}{an \eqn{n} by \eqn{d} matrix of multivariate observations}

\item{qlev}{vector of percentiles between 0 and 1}

\item{nq}{number of quantiles of the structural variable at which to form a grid; only used if \code{u = NULL}.}

\item{qlim}{limits for the sequence \code{u} of the structural variable}

\item{estimator}{string giving estimator to employ}

\item{confint}{string indicating the type of confidence interval, one of \code{"wald"} or \code{"lrt"}}

\item{level}{the confidence level required (default to 0.95).}

\item{margtrans}{string giving the marginal transformation, one of \code{emp} for rank-based transformation or \code{none} if data are already on the uniform scale}

\item{ties.method}{string indicating the type of method for \code{rank}; see \code{\link[base]{rank}} for a list of options. Default to \code{"random"}}

\item{plot}{logical; if \code{TRUE}, return a plot}

\item{mqlev}{marginal quantile levels for semiparametric estimation for estimator \code{kj}; data above this are modelled using a generalized Pareto distribution. If missing, empirical estimation is used throughout}

\item{...}{additional arguments to \code{taildep}, currently ignored}
}
\value{
a data frame
\itemize{
\item \code{qlev}: quantile level of estimates
\item \code{coef}: point estimates
\item \code{lower}: lower bound of confidence interval
\item \code{upper}: lower bound of confidence interval
}
}
\description{
For data with unit Pareto margins, the coefficient of tail dependence \eqn{\eta} is defined  via \deqn{\Pr(\min(X) > x) = L(x)x^{-1/\eta},}
where \eqn{L(x)} is a slowly varying function. Ignoring the latter, several estimators of \eqn{\eta} can be defined. In unit Pareto margins, \eqn{\eta} is a nonnegative shape parameter that can be estimated by fitting a generalized Pareto distribution above a high threshold. In exponential margins, \eqn{\eta} is a scale parameter and the maximum likelihood estimator of the latter is the Hill estimator. Both methods are based on peaks-over-threshold and the user can choose between pointwise confidence obtained through a likelihood ratio test statistic (\code{"lrt"}) or the Wald statistic (\code{"wald"}).
}
\details{
The most common approach for estimation is the empirical survival copula, by evaluating the proportion of sample minima with uniform margins that exceed a given \eqn{x}. An alternative estimator uses a smoothed estimator of the survival copula using Bernstein polynomial, resulting in the so-called \code{betacop} estimator. Approximate pointwise confidence intervals for the latter are obtained by assuming the proportion of points is binomial.
}
\examples{
\dontrun{
set.seed(765)
# Max-stable model
dat <- rmev(n = 1000, d = 2, param = 0.7, model = "log")
xdep.eta(dat, confint = 'wald')
}
}
\references{
Ledford, A.W. and J. A. Tawn (1996), Statistics for near independence in multivariate extreme values. \emph{Biometrika}, \bold{83}(1), 169--187.
}
