% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mfgarch.R
\name{fit_mfgarch}
\alias{fit_mfgarch}
\title{This function estimates a multiplicative mixed-frequency GARCH model. For the sake of numerical stability, it is best to multiply log returns by 100.}
\usage{
fit_mfgarch(data, y, x = NULL, K = NULL, low.freq = "date",
  var.ratio.freq = NULL, gamma = TRUE, weighting = "beta.restricted",
  x.two = NULL, K.two = NULL, low.freq.two = NULL, weighting.two = NULL,
  multi.start = FALSE)
}
\arguments{
\item{data}{data frame containing a column named date of type 'Date'.}

\item{y}{name of high frequency dependent variable in df.}

\item{x}{covariate employed in mfGARCH.}

\item{K}{an integer specifying lag length K in the long-term component.}

\item{low.freq}{a string of the low frequency variable in the df.}

\item{var.ratio.freq}{specify a frequency column on which the variance ratio should be calculated.}

\item{gamma}{if TRUE, an asymmetric GJR-GARCH is used as the short-term component. If FALSE, a simple GARCH(1,1) is employed.}

\item{weighting}{specifies the weighting scheme employed in the long-term component. Options are "beta.restricted" (default) or "beta.unrestricted"}

\item{x.two}{optional second covariate}

\item{K.two}{lag lgenth of optional second covariate}

\item{low.freq.two}{low frequency of optional second covariate}

\item{weighting.two}{specifies the weighting scheme employed in the optional second long-term component. Currently, the only option is "beta.restricted"}

\item{multi.start}{if TRUE, optimization is carried out with multiple starting values}
}
\description{
This function estimates a multiplicative mixed-frequency GARCH model. For the sake of numerical stability, it is best to multiply log returns by 100.
}
\examples{
\dontrun{
fit_mfgarch(data = df_financial, y = "return", x = "nfci", low.freq = "week", K = 52)
fit_mfgarch(data = df_mfgarch, y = "return", x = "nfci", low.freq = "year_week", K = 52,
x.two = "dindpro", K.two = 12, low.freq.two = "year_month", weighting.two = "beta.restricted")
}
}
\keyword{fit_mfgarch}
