% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{transform_matrix}
\alias{transform_matrix}
\title{Function to transform each column of matrix using final FP powers or acd}
\usage{
transform_matrix(
  x,
  power_list,
  center,
  acdx,
  keep_x_order = FALSE,
  acd_parameter_list = NULL,
  check_binary = TRUE
)
}
\arguments{
\item{x}{a matrix with all continuous variables shifted and scaled.}

\item{power_list}{a named list of FP powers to be applied to the columns of
\code{x}. Only variables named in this list are transformed.}

\item{center}{a named logical vector specifying whether the columns in \code{x}
should be centered. Centering will occur after transformations and will be
done separately for each individual column of the transformed data matrix.}

\item{acdx}{a named logical vector specifying the use of acd transformation.}

\item{keep_x_order}{a logical indicating whether the order of columns
should be kept as in the input matrix \code{x}, of if the columns should be
ordered according to \code{power_list}. The default is \code{FALSE}, since
the ordering by \code{power_list} reflects the \code{xorder} argument in \code{\link[=mfp2]{mfp2()}}.}

\item{acd_parameter_list}{a named list. Only required when transformation
are to be applied to new data. Entries must correspond to the entries where
\code{acdx} is set to \code{TRUE}. Each components is to be passed to
\code{\link[=transform_vector_acd]{transform_vector_acd()}}. The default value \code{NULL} indicates that the
parameters for the acd transformations are to be estimated.}

\item{check_binary}{passed to \code{\link[=transform_vector_fp]{transform_vector_fp()}}.}
}
\value{
If all elements of \code{power_list} are \code{NA} then this function returns \code{NULL}.
Otherwise a list with three entries: the first \code{x_transformed} is a matrix
with transformed variables as named in \code{power_list}.
The number of columns may possibly be different to the
input matrix due to higher order FP transformations.
The second entry \code{centers} stores the values used to center the variables if
for any variable \code{center = TRUE} (note that usually all variables are
centered, or none of them).
The third entry \code{acd_parameter} stores a named list of estimated
\code{acd_parameters}. May be empty if no ACD transformation is applied.
}
\description{
Function to transform each column of matrix using final FP powers or acd
}
\details{
For details on the transformations see \code{\link[=transform_vector_fp]{transform_vector_fp()}} and
\code{\link[=transform_vector_acd]{transform_vector_acd()}}.
}
\section{Column names}{

Generally the original variable names are suffixed with ".i", where
i enumerates the powers for a given variable in \code{power_list}. If a term
uses an acd transformation, then the variable is prefixed with \code{A_}.
}

\examples{
x = matrix(1:100, nrow = 10)
colnames(x) = paste0("x", 1:ncol(x))
powx = setNames(replicate(ncol(x), c(1,2), simplify = FALSE), colnames(x))
center = setNames(rep(FALSE, ncol(x)), colnames(x))
acdx = setNames(rep(FALSE, ncol(x)), colnames(x))
transform_matrix(x, powx, center, acdx)

}
