% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_gridQCheck1D.R
\name{l_gridQCheck1D}
\alias{l_gridQCheck1D}
\title{Checking sign of residuals along one covariate}
\usage{
l_gridQCheck1D(qu = NULL, n = 20, level = 0.8, ...)
}
\arguments{
\item{qu}{the quantile of interest. Should be in (0, 1).}

\item{n}{number of grid intervals.}

\item{level}{the level of the confidence intervals plotted.}

\item{...}{graphical arguments to be passed to \code{ggplot2::geom_point}.}
}
\value{
An object of class \code{gamLayer}
}
\description{
This layer is mainly useful when checking quantile GAMs fitted using the \code{qgam}
package. The residuals, r, are binned according to the corresponding value of a
covariate, x. Then the proportions of negative residuals within each bin are calculated, and
compared with the theoretical value, \code{qu}. Confidence intervals for the proportion
of negative residuals can be derived using binomial quantiles (under an independence
assumption). To be used in conjuction with \link{check1D}.
}
\examples{
# Simulate some data
library(mgcViz)
set.seed(3841)
dat <- gamSim(1,n=400,dist="normal",scale=2)
dat$fac <- as.factor( sample(letters[1:8], nrow(dat), replace = TRUE) ) 
fit <- qgam(y~s(x1)+s(x2)+s(x3)+fac, data=dat, err = 0.05, qu = 0.4)
fit <- getViz(fit)

# "x0" effect is missing, but should be there. l_gridQCheck1D shows
# that fraction of negative residuals is quite different from the theoretical 0.4
# in several places along "x0".
check1D(fit, dat$x0) + l_gridQCheck1D(qu = 0.4, n = 20)
# The problem gets better if s(x0) is added to the model.

# Works also with factor variables
check1D(fit, "fac") + l_gridQCheck1D(qu = 0.4)
}
