% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSnpSearch_function.R
\name{makeSnpSearch}
\alias{makeSnpSearch}
\title{Returns gene names with a given SNP}
\usage{
makeSnpSearch(mgl, term = c(""), snp, saveFile = FALSE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{term}{Character vector representing phenotype of interest}

\item{snp}{List produced by \code{\link{makePhenotypes}}}

\item{saveFile}{A logical flag indicating whether a csv file ('SnpSearch_[term].csv') should be saved in the current directory}
}
\description{
\code{makePhenotypeSearch} returns a character vector of gene names.
}
\details{
Of interest maybe groups of genes that have the same associated SNP
}
\examples{
exMgl() -> myMgl
makeSnps(myMgl, saveFile = FALSE) -> mySnps
makeSnpSearch(myMgl, term = '10_51518910_G_A_b37', snp = mySnps, saveFile = FALSE) -> mySnpSearch

}
\seealso{
\code{\link{makePhenotypes}}

Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

