% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGWRSAR.R
\name{MGWRSAR}
\alias{MGWRSAR}
\title{Estimation of linear and local linear model with spatial autocorrelation model (mgwrsar).}
\usage{
MGWRSAR(formula,data,coord,fixed_vars=NULL,kernels,H,
Model='GWR',control=list())
}
\arguments{
\item{formula}{a formula.}

\item{data}{a dataframe or a spatial dataframe (sp package).}

\item{coord}{default NULL, a dataframe or a matrix with coordinates, not
required if data is a spatial dataframe.}

\item{fixed_vars}{a vector with the names of spatiallay constant coefficient for
mixed model. All other variables present in formula are supposed to be spatially
varying. If empty or NULL (default), all variables in formula are supposed to be
spatially varying.}

\item{kernels}{vector containing the kernel types. Possible types: k nearest
neighbors ("knn"), bisquare ("bisq"), adaptative bisquare ("bisq_knn"), gaussian
("gauss"), adaptative gaussian ("gauss_adapt").}

\item{H}{vector containing the bandwidth parameters for the kernel funcitons.}

\item{Model}{character containing the type of model: Possible values are "OLS",
"SAR", "GWR" (default), "MGWR" , "MGWRSAR_0_0_kv","MGWRSAR_1_0_kv",
"MGWRSAR_0_kc_kv", "MGWRSAR_1_kc_kv", "MGWRSAR_1_kc_0". See Details for more
explanation.}

\item{control}{list of extra control arguments for MGWRSAR wrapper - see Details below}
}
\value{
MGWRSAR returns an object  of class mgwrsar with at least the following components:
\item{Betav}{ matrix of coefficients of dim(n,kv) x kv.}
\item{Betac}{ vector of coefficients of length kc.}
\item{Model}{ The sum of square residuals.}
\item{Y}{ The dependent variable.}
\item{XC}{ The explanatory variables with constant coefficients.}
\item{XV}{ The explanatory variables with varying coefficients.}
\item{X}{ The explanatory variables.}
\item{W}{ The spatial weight matrix for spatial dependence.}
\item{isgcv}{ if gcv has been computed.}
\item{edf}{ The estimated degrees of freedom.}
\item{formula}{The formula.}
\item{data}{ The dataframe used for computation.}
\item{Method}{ The type of model.}
\item{coord}{ The spatial coordinates of observations.}
\item{H}{ The bandwidth vector.}
\item{fixed_vars}{ The names of constant coefficients.}
\item{kernels}{ The kernel vector.}
\item{SSR}{ The sum of square residuals.}
\item{residuals}{ The vector of residuals.}
\item{fit}{ the vector of fitted values.}
\item{sev}{ local standard error of parameters.}

MGWRSAR is is a wrapper function for estimating linear and local linear model
with spatial autocorrelation that  allows to estimate the following models :
\eqn{y=\beta_c X_c+\,\epsilon_i} (OLS)

\eqn{y=\beta_v(u_i,v_i) X_v+\,\epsilon_i} (GWR)

\eqn{y=\beta_c X_c+\beta_v(u_i,v_i) X_v+\,\epsilon_i} (MGWR)

\eqn{y=\lambda Wy+\beta_c X_c+\,\epsilon_i} (MGWR-SAR(0,k,0))

\eqn{y=\lambda Wy+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(0,0,k))

\eqn{y=\lambda Wy+\beta_c X_c+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(0,k_c,k_v))

\eqn{y=\lambda(u_i,v_i) Wy+\beta_c X_c+\,\epsilon_i} (MGWR-SAR(1,k,0))

\eqn{y=\lambda(u_i,v_i)Wy+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(1,0,k))

\eqn{y=\lambda(u_i,v_i)Wy+\beta_cX_c+\beta_v(u_i,v_i)X_v+\,\epsilon_i} (MGWR-SAR(1,k_c,k_v))

When model imply spatial autocorrelation, a row normalized spatial weight matrix must be provided.
2SLS and Best 2SLS method can be used.
When model imply local regression, a bandwidth and a kernel type must be provided. Optimal bandwidth can be estimated
using bandwidths_mgwrsar function.
When model imply mixed local regression, the names of stationary covariates must be provided.

#' In addition to the ability of considering spatial autocorrelation in GWR/MGWR like models,
MGWRSAR function introduces several useful technics for estimating local regression with space coordinates:
\itemize{
\item{it uses RCCP and RCCPeigen code that speed up computation and allows parallel computing via doMC package;}
\item{it allows to drop out variables with not enough local variance in local regression, which allows to consider dummies in GWR/MGWR framework without trouble.}
\item{it allows to drop out local outliers in local regression.}
\item{it allows to consider additional variable for kernel, including  time (asymetric kernel) and categorical variables (see Li and Racine 2010). Experimental version.}
}
}
\description{
MGWRSAR is is a wrapper function for estimating linear and local linear models
with spatial autocorrelation (SAR models with spatially varying coefficients).
}
\details{
\itemize{
\item{Z}{ a matrix of variables for genralized kernel product, default NULL.}
\item{W}{ a row-standardized spatial weight matrix for Spatial Aurocorrelation, default NULL.}
\item{type}{ verbose mode, default FALSE.}
\item{kernel_w}{ the type of kernel for computing W, default NULL.}
\item{h_w}{ the bandwidth value for computing W, default 0.}
\item{Method}{ estimation technique for computing the models with Spatial Dependence. '2SLS' or 'B2SLS', default '2SLS'.}
\item{isgcv}{ computing CV criteria (for example for selecting optimal bandwidth), default FALSE.}
\item{isfgcv}{ if TRUE, simplify the computation of CV criteria (remove or not i
when using local instruments for model with lambda spatially varying), default TRUE.}
\item{maxknn}{ when n >NmaxDist, only the maxknn first neighbours are used for distance compution, default 500.}
\item{NmaxDist}{ when n >NmaxDist only the maxknn first neighbours are used for distance compution, default 5000}
\item{verbose}{ verbose mode, default FALSE.}
}
}
\examples{
\donttest{
data(data_mgwrsar)
coord=as.matrix(mydata[,c("x_lat","y_lon")])
model_GWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata,coord=coord,
fixed_vars=NULL,kernels=c('gauss_knn'),
H=120, Model = 'GWR',control=list())
summary_mgwrsar(model_GWR)

W=KNN(coord,8)
model_MGWRSAR_0_kc_kv<-MGWRSAR(formula = 'Y_mgwrsar_0_kc_kv~X1+X2+X3', data = mydata,
coord=coord,fixed_vars='Intercept',kernels=c('gauss_adapt'),
H=120, Model = 'MGWRSAR_0_kc_kv',control=list(W=W))
summary_mgwrsar(model_MGWRSAR_0_kc_kv)
}
}
\references{
Geniaux, G. and Martinetti, D. (2017). A new method for dealing simultaneously with spatial autocorrelation and spatial heterogeneity in regression models. Regional Science and Urban Economics. (https://doi.org/10.1016/j.regsciurbeco.2017.04.001)

McMillen, D. and Soppelsa, M. E. (2015). A conditionally parametric probit model of
microdata land use in chicago. Journal of Regional Science, 55(3):391-415.

Loader, C. (1999). Local regression and likelihood, volume 47. springer New York.

Franke, R. and Nielson, G. (1980). Smooth interpolation of large sets of scattered data.
International journal for numerical methods in engineering, 15(11):1691-1704.
}
\seealso{
bandwidths_mgwrsar, summary_mgwrsar, plot_mgwrsar, predict_mgwrsar, kernelW_C
}
