% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM2.R
\name{KM2}
\alias{KM2}
\title{Estimates the survival function for a bivariate outcome}
\usage{
KM2(
  Y1,
  Y2,
  Delta1,
  Delta2,
  newT1 = NULL,
  newT2 = NULL,
  estimator = c("dabrowska", "volterra", "prentice-cai"),
  conf.int = FALSE,
  R = 1000,
  ...
)
}
\arguments{
\item{Y1, Y2}{Vectors of event times (continuous).}

\item{Delta1, Delta2}{Vectors of censoring indicators (1=event,
0=censored).}

\item{newT1, newT2}{Optional vectors of new times at which to estimate
the survival function. Defaults to the unique values in Y1/Y2 if not
specified.}

\item{estimator}{Which estimator of the survival function should be used.
Possible values include "dabrowska", "volterra", and "prentice-cai".
Defaults to "dabrowska".}

\item{conf.int}{Should bootstrap confidence intervals be computed?}

\item{R}{Number of bootstrap replicates. This argument is passed to the
boot function. Defaults to 1000. Ignored if conf.int is FALSE.}

\item{...}{Additional arguments to the boot function.}
}
\value{
A list containing the following elements:
\describe{
\item{T1:}{Unique values of Y1 at which Fhat was computed}
\item{T2:}{Unique values of Y2 at which Fhat was computed}
\item{Fhat:}{Estimated survival function (computed at T1, T2)}
\item{Fhat.lci:}{Lower 95\% confidence bounds for Fhat}
\item{Fhat.uci:}{Upper 95\% confidence bounds for Fhat}
\item{Fmarg1:}{Estimated marginal survival function for variable 1
(computed at newT1)}
\item{Fmarg1.lci:}{Lower 95\% confidence bounds for Fmarg1}
\item{Fmarg1.uci:}{Upper 95\% confidence bounds for Fmarg1}
\item{Fmarg2:}{Estimated marginal survival function for variable 2
(computed at newT2)}
\item{Fmarg2.lci:}{Lower 95\% confidence bounds for Fmarg2}
\item{Fmarg2.uci:}{Upper 95\% confidence bounds for Fmarg2}
\item{Fhat_est:}{Estimated survival function (computed at newT1, newT2)}
\item{Fhat_est.lci:}{Lower 95\% confidence bounds for Fhat_est}
\item{Fhat_est.uci:}{Upper 95\% confidence bounds for Fhat_est}
\item{CR:}{Estimated cross ratio (computed at T1, T2)}
\item{KT:}{Estimated Kendall\'s tau (computed at T1, T2)}
\item{CR_est:}{Estimated cross ratio (computed at newT1, newT2)}
\item{KT_est:}{Estimated Kendall\'s tau (computed at newT1, newT2)}
}
}
\description{
Computes the survival function for a bivariate outcome using one of
three possible estimators. The survival function for a bivariate outcome
is analogous to the Kaplan-Meier estimator for a univariate outcome.
Optionally (bootstrap) confidence intervals for the survival function
may also be computed.
}
\section{Details}{

If conf.int is TRUE, confidence intervals will be computed using the
boot function in the boot package. Currently only 95\% confidence
intervals computed using the percentile method are implemented. If
conf.int is FALSE, confidence intervals will not be computed, and
confidence bounds will not be returned in the output.
}

\examples{
x <- genClayton2(1000, 0, 1, 1, 2, 2)
x.km2 <- KM2(x$Y1, x$Y2, x$Delta1, x$Delta2)
\donttest{x.km2.ci <- KM2(x$Y1, x$Y2, x$Delta1, x$Delta2, conf.int=TRUE)}
}
\references{
Prentice, R., Zhao, S. "Nonparametric estimation of the multivariate
survivor function: the multivariate Kaplan–Meier estimator", Lifetime
Data Analysis (2018) 24:3-27.
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
\seealso{
\code{\link[boot]{boot}}
}
