% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi4limma.R
\name{mi4limma}
\alias{mi4limma}
\title{Title}
\usage{
mi4limma(qData, sTab, VarRubin, comp.type = "OnevsOne", robust = FALSE)
}
\arguments{
\item{qData}{A matrix of quantitative data, without any missing values.}

\item{sTab}{The data.frame which correspond to the pData function of MSnbase}

\item{VarRubin}{A variance-covariance matrix}

\item{comp.type}{A string that corresponds to the type of comparison. Values are: 'anova1way', 'OnevsOne' and 'OnevsAll'; default is 'OnevsOne'.}

\item{robust}{logical, should the estimation of df.prior and var.prior be robustified against outlier sample variances? (as in limma's eBayes)}
}
\value{
A list of two dataframes : logFC and P_Value. The first one contains the logFC values of all the comparisons (one column for one comparison), the second one contains the pvalue of all the comparisons (one column for one comparison). The names of the columns for those two dataframes are identical and correspond to the description of the comparison.
}
\description{
Title
}
\examples{
set.seed(2016)
data(qData)
data(sTab)
fit.limma <- mi4limma(qData, sTab, diag(1,2))
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
