% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_topic.R
\name{assign_topic}
\alias{assign_topic}
\title{Assign topics based on precalculated scores}
\usage{
assign_topic(
  df,
  col.topic,
  threshold,
  topic.names = NULL,
  col.topic.name = "Topic",
  col.pmid = "PMID",
  discard = FALSE
)
}
\arguments{
\item{df}{Data frame containing precalculated topic scores and PubMed-IDs.}

\item{col.topic}{Character vector. Vector with column names containing
precalculated topic scores.}

\item{threshold}{Integer vector. Vector containing thresholds for topic
columns. Positions in \code{threshold} correspond to positions in
\code{col.topic}.}

\item{topic.names}{Character vector. Optional. Vector containing names of new
topics. Positions in \code{topic.names} correspond to positions in
\code{col.topic}. If \code{topic.names} is not provided, \code{col.topic} is used
to name the new topics.}

\item{col.topic.name}{String. Name of the new topic column.}

\item{col.pmid}{String. Column containing PubMed-IDs.}

\item{discard}{Boolean. If \code{discard = TRUE}, only abstracts with
a newly assigned topic are kept. Abstracts without a newly assigned topic
are discarded.}
}
\value{
Data frame with topics based on precalculated
topic scores.
}
\description{
Assign topics to abstracts based on precalculated scores.
}
\details{
Assign topics to abstracts based on precalculated scores.
\code{assign_topic()} compares different precalculated topic scores and
assigns the abstract to the topic with the highest score. If there is a
tie between topic scores, the abstract is assigned to all topics in question.
If an abstract matches no topic, it is assigned to the topic "Unknown".
}
\seealso{
\code{\link[=calculate_score_topic]{calculate_score_topic()}}, \code{\link[=plot_score_topic]{plot_score_topic()}},
\code{\link[=add_col_topic]{add_col_topic()}}

Other score functions: 
\code{\link{calculate_score_animals}()},
\code{\link{calculate_score_biomarker}()},
\code{\link{calculate_score_patients}()},
\code{\link{calculate_score_topic}()},
\code{\link{plot_score_animals}()},
\code{\link{plot_score_biomarker}()},
\code{\link{plot_score_patients}()},
\code{\link{plot_score_topic}()}
}
\concept{score functions}
