% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_count.R
\name{compare_mir_count_log2}
\alias{compare_mir_count_log2}
\title{Compare log2-frequency count of miRNA names between two topics}
\usage{
compare_mir_count_log2(
  df,
  mir,
  topic = NULL,
  normalize = TRUE,
  col.topic = Topic,
  col.mir = miRNA,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, topics, and PubMed-IDs.}

\item{mir}{Character vector. Vector specifying which miRNA names to
compare.}

\item{topic}{Character vector. Optional. Vector specifying which
topics to compare. If \code{topic = NULL}, all topics in \code{df} are used.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, proportion of abstracts
mentioning a miRNA name compared to all abstracts of a topic are used. If
\code{normalize = FALSE}, the absolute number of abstracts mentioning a miRNA
name is used.}

\item{col.topic}{Symbol. Column containing topics.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
List containing bar plot comparing the log2-frequency count of miRNA names between
two topics and its corresponding data frame.
}
\description{
Compare log2-frequency count of miRNA names between two topics
}
\details{
Compare log2-frequency count of miRNA names between two topics by plotting the
log2-ratio of the miRNA count in two topics. The miRNA count per topic can
either be normalized, thus taking the proportion of abstracts mentioning
a miRNA name compared to all abstracts in a topic, or not normalized, thus
taking the absolute number of abstracts mentioning a miRNA in a topic.
The log2-plot is greatly inspired by the book
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.” by
Silge and Robinson.
}
\references{
Silge, Julia, and David Robinson. 2016.
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.”
JOSS 1 (3). The Open Journal. https://doi.org/10.21105/joss.00037.
}
\seealso{
\code{\link[=compare_mir_count]{compare_mir_count()}}, \code{\link[=compare_mir_count_unique]{compare_mir_count_unique()}}

Other compare functions: 
\code{\link{compare_mir_count_unique}()},
\code{\link{compare_mir_count}()},
\code{\link{compare_mir_terms_log2}()},
\code{\link{compare_mir_terms_scatter}()},
\code{\link{compare_mir_terms_unique}()},
\code{\link{compare_mir_terms}()}
}
\concept{compare functions}
