% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_count.R
\name{compare_mir_count_unique}
\alias{compare_mir_count_unique}
\title{Compare top count of unique miRNA names per topic}
\usage{
compare_mir_count_unique(
  df,
  top = 5,
  topic = NULL,
  normalize = TRUE,
  colour = "steelblue3",
  col.topic = Topic,
  col.mir = miRNA,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, topics, and PubMed-IDs.}

\item{top}{Integer. Specifies number of top unique miRNAs to plot.}

\item{topic}{Character vector. Optional. Vector specifying which
topics to compare. If \code{topic = NULL}, all topics in \code{df} are used.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, proportion of abstracts
mentioning a miRNA name compared to all abstracts of a topic are used. If
\code{normalize = FALSE}, the absolute number of abstracts mentioning a miRNA
name is used.}

\item{colour}{String. Colour of bar plot.}

\item{col.topic}{Symbol. Column containing topics.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Bar plot comparing frequency of unique miRNA count per topic.
}
\description{
Compare top count of unique miRNA names per topic
}
\details{
Compare top count of unique miRNA names per topic by plotting the
the miRNA count of unique miRNAs per topic. Per topic, the unique miRNAs
are identified and their count is plotted.
The miRNA count can either be normalized, thus taking the proportion of abstracts mentioning
a miRNA name compared to all abstracts in a topic, or not normalized, thus
taking the absolute number of abstracts mentioning a miRNA in a topic.
}
\seealso{
\code{\link[=compare_mir_count]{compare_mir_count()}}, \code{\link[=compare_mir_count_log2]{compare_mir_count_log2()}}

Other compare functions: 
\code{\link{compare_mir_count_log2}()},
\code{\link{compare_mir_count}()},
\code{\link{compare_mir_terms_log2}()},
\code{\link{compare_mir_terms_scatter}()},
\code{\link{compare_mir_terms_unique}()},
\code{\link{compare_mir_terms}()}
}
\concept{compare functions}
