% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirna_year_new_and_trend.R
\name{plot_mir_new}
\alias{plot_mir_new}
\title{Plot number of newly mentioned miRNA names/year}
\usage{
plot_mir_new(
  df,
  threshold = 1,
  start = NULL,
  end = NULL,
  colour = "steelblue3",
  col.mir = miRNA,
  col.year = Year,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names and publication years.}

\item{threshold}{Integer. Specifies how often a miRNA must be
mentioned in a year to be considered "mentioned".}

\item{start}{Integer. Optional. Beginning of publication period.
If \code{start = NULL}, \code{start} is set to the least recent year in \code{df}.}

\item{end}{Integer. Optional. End of publication period.
If \code{end = NULL}, \code{end} is set to the most recent year in \code{df}.}

\item{colour}{String. Colour of bar plot.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.year}{Symbol. Column containing publication year.}

\item{title}{String. Plot title.}
}
\value{
Bar plot displaying the number of newly mentioned miRNA names/year.
}
\description{
Plot number of newly mentioned miRNA names/year.
}
\details{
Plot how many miRNAs are mentioned for the first time in different year.
If a miRNA is considered to be "mentioned" in a year can be regulated
via the \code{threshold} argument. If, for example, \code{threshold} is set to 3, but a
miRNA is mentioned only twice in a year, it is not considered
to be "mentioned" for this year.
}
\seealso{
Other miR development functions: 
\code{\link{plot_mir_development}()}
}
\concept{miR development functions}
