% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parlmice.R
\name{parlmice}
\alias{parlmice}
\title{Wrapper function that runs MICE in parallel}
\usage{
parlmice(
  data,
  m = 5,
  seed = NA,
  cluster.seed = NA,
  n.core = NULL,
  n.imp.core = NULL,
  cl.type = "PSOCK",
  ...
)
}
\arguments{
\item{data}{A data frame or matrix containing the incomplete data. Similar to 
the first argument of \code{\link{mice}}.}

\item{m}{The number of desired imputated datasets. By default $m=5$ as with \code{mice}}

\item{seed}{A scalar to be used as the seed value for the mice algorithm within 
each parallel stream. Please note that the imputations will be the same for all 
streams and, hence, this should be used if and only if \code{n.core = 1} and 
if it is desired to obtain the same output as under \code{mice}.}

\item{cluster.seed}{A scalar to be used as the seed value. It is recommended to put the 
seed value here and not outside this function, as otherwise the parallel processes
will be performed with separate, random seeds.}

\item{n.core}{A scalar indicating the number of cores that should be used.}

\item{n.imp.core}{A scalar indicating the number of imputations per core.}

\item{cl.type}{The cluster type. Default value is \code{"PSOCK"}. Posix machines (linux, Mac)
generally benefit from much faster cluster computation if \code{type} is set to \code{type = "FORK"}.}

\item{...}{Named arguments that are passed down to function \code{\link{mice}} or
\code{\link{makeCluster}}.}
}
\value{
A mids object as defined by \code{\link{mids-class}}
}
\description{
This is a wrapper function for \code{\link{mice}}, using multiple cores to 
execute \code{\link{mice}} in parallel. As a result, the imputation 
procedure can be sped up, which may be useful in general.
}
\details{
This function relies on package \code{\link{parallel}}, which is a base
package for R versions 2.14.0 and later. We have chosen to use parallel function 
\code{parLapply} to allow the use of \code{parlmice} on Mac, Linux and Windows
systems. For the same reason, we use the Parallel Socket Cluster (PSOCK) type by default. 

On systems other than Windows, it can be hugely beneficial to change the cluster type to 
\code{FORK}, as it generally results in improved memory handling. When memory issues 
arise on a Windows system, we advise to store the multiply imputed datasets, 
clean the memory by using \code{\link{rm}} and \code{\link{gc}} and make another 
run using the same settings.

This wrapper function combines the output of \code{\link{parLapply}} with
function \code{\link{ibind}} in \code{\link{mice}}. A \code{mids} object is returned
and can be used for further analyses. 

Note that if a seed value is desired, the seed should be entered to this function
with argument \code{seed}. Seed values outside the wrapper function (in an 
R-script or passed to \code{\link{mice}}) will not result to reproducible results. 
We refer to the manual of \code{\link{parallel}} for an explanation on this matter.
}
\examples{
# 150 imputations in dataset nhanes, performed by 3 cores  
\dontrun{
imp1 <- parlmice(data = nhanes, n.core = 3, n.imp.core = 50)
# Making use of arguments in mice. 
imp2 <- parlmice(data = nhanes, method = "norm.nob", m = 100)
imp2$method
fit <- with(imp2, lm(bmi ~ hyp))
pool(fit)
}

}
\references{
Schouten, R. and Vink, G. (2017). parlmice: faster, paraleller, micer. 
\url{https://gerkovink.github.io/parlMICE/Vignette_parlMICE.html}

#'Van Buuren, S. (2018). 
\href{https://stefvanbuuren.name/fimd/parallel-computation.html}{\emph{Flexible Imputation of Missing Data. Second Edition.}}
Chapman & Hall/CRC. Boca Raton, FL.
}
\seealso{
\code{\link{parallel}}, \code{\link{parLapply}}, \code{\link{makeCluster}},
\code{\link{mice}}, \code{\link{mids-class}}
}
\author{
Gerko Vink, 2018, based on an earlier version by Rianne Schouten and Gerko Vink, 2017.
}
