% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genusLookup.R
\name{fullTaxonomy}
\alias{fullTaxonomy}
\title{The full taxonomy of a genus}
\usage{
fullTaxonomy(genera)
}
\arguments{
\item{genera}{A vector of texts, the genera names to look up.}
}
\value{
A character vector containing the taxonomy information.
}
\description{
Converts a genus to a string containing the full taxonomy.
}
\details{
The argument \code{genera} must consist of names in the \code{Genus} column of the data
set \code{\link{taxonomy.table}}.


"k__<...>;p__<...>;c__<...>;o__<...>;f__<...>;g__<...>;"

where <...> is some proper text.
}
\examples{
genera <-  c("Bacillus","Clostridium","Hyphomonas") 
fullTaxonomy(genera)


}
\seealso{
\code{\link{taxonomy.table}}, \code{\link{genusLookup}}.
}
\author{
Lars Snipen.
}
