% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_cnes.R
\name{process_cnes}
\alias{process_cnes}
\title{Process CNES variables from DataSUS}
\usage{
process_cnes(
  data,
  information_system = c("CNES-ST", "CNES-PF"),
  nomes = TRUE,
  municipality_data = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} created by \code{fetch_datasus()}.}

\item{information_system}{\code{string}. \code{CNES-ST} or \code{CNES-PF}}

\item{nomes}{optional logical. \code{TRUE} by default, add  \code{FANTASIA} and \code{RAZÃO SOCIAL} names to the dataset.}

\item{municipality_data}{optional logical. \code{TRUE} by default, creates new variables in the dataset informing the full name and other details about the municipality of residence.}
}
\value{
a \code{data.frame} with the processed data.
}
\description{
\code{process_cnes} processes CNES variables retrieved by \code{fetch_datasus()}.
}
\details{
This function processes CNES-ST (Estabelecimentos) or CNES-PF (Pessoa f\\u00edsica) variables retrieved by \code{fetch_datasus()}, informing labels for categoric variables including NA values.
}
\examples{
process_cnes(cnes_st_sample, information_system = "CNES-ST")
process_cnes(cnes_pf_sample, information_system = "CNES-PF")

}
