#' Similarity API
#'
#' @export
#' @param s1,s2 (character) strings 1 and 2. required
#' @param method (character) one of GET (default) or POST
#' @param key (character) microsoft academic API key, see [microdemic]
#' @param ... curl options passed on to [crul::HttpClient]
#' @examples \dontrun{
#' s1 <- "Using complementary priors, we derive a fast greedy algorithm that
#' can learn deep directed belief networks one layer at a time, provided the
#' top two layers form an undirected associative memory"
#'
#' s2 <- "Deepneural nets with a large number of parameters are very powerful
#' machine learning systems. However, overfitting is a serious problem in
#' such networks"
#'
#' ma_similarity(s1, s2)
#'
#' ma_similarity(s1, s2, method = "POST")
#' }
ma_similarity <- function(s1, s2, method = "GET", key = NULL, ...) {
  if (!method %in% c("GET", "POST")) stop("'method' must be one of GET or POST")
  if (method == "GET") {
    args <- comp(list(s1 = s1, s2 = s2))
    ma_HTTP("academic/v1.0/similarity", args, key, ...)
  } else {
    args <- sprintf("s1=%s&s2=%s", s1, s2)
    ma_HTTP("academic/v1.0/similarity", NULL, key = key,
            method = 'POST', body = args, ...)
  }
}
